package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NamespaceStatusBuilder extends NamespaceStatusFluent<NamespaceStatusBuilder> implements VisitableBuilder<NamespaceStatus,NamespaceStatusBuilder>{
  public NamespaceStatusBuilder() {
    this(new NamespaceStatus());
  }
  
  public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent) {
    this(fluent, new NamespaceStatus());
  }
  
  public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent,NamespaceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamespaceStatusBuilder(NamespaceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamespaceStatusFluent<?> fluent;
  
  public NamespaceStatus build() {
    NamespaceStatus buildable = new NamespaceStatus(fluent.buildConditions(),fluent.getPhase());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}