package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LabelSelectorRequirementBuilder extends LabelSelectorRequirementFluent<LabelSelectorRequirementBuilder> implements VisitableBuilder<LabelSelectorRequirement,LabelSelectorRequirementBuilder>{
  public LabelSelectorRequirementBuilder() {
    this(new LabelSelectorRequirement());
  }
  
  public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent) {
    this(fluent, new LabelSelectorRequirement());
  }
  
  public LabelSelectorRequirementBuilder(LabelSelectorRequirementFluent<?> fluent,LabelSelectorRequirement instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LabelSelectorRequirementBuilder(LabelSelectorRequirement instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LabelSelectorRequirementFluent<?> fluent;
  
  public LabelSelectorRequirement build() {
    LabelSelectorRequirement buildable = new LabelSelectorRequirement(fluent.getKey(),fluent.getOperator(),fluent.getValues());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}