package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureDiskVolumeSourceBuilder extends AzureDiskVolumeSourceFluent<AzureDiskVolumeSourceBuilder> implements VisitableBuilder<AzureDiskVolumeSource,AzureDiskVolumeSourceBuilder>{
  public AzureDiskVolumeSourceBuilder() {
    this(new AzureDiskVolumeSource());
  }
  
  public AzureDiskVolumeSourceBuilder(AzureDiskVolumeSourceFluent<?> fluent) {
    this(fluent, new AzureDiskVolumeSource());
  }
  
  public AzureDiskVolumeSourceBuilder(AzureDiskVolumeSourceFluent<?> fluent,AzureDiskVolumeSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureDiskVolumeSourceBuilder(AzureDiskVolumeSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureDiskVolumeSourceFluent<?> fluent;
  
  public AzureDiskVolumeSource build() {
    AzureDiskVolumeSource buildable = new AzureDiskVolumeSource(fluent.getCachingMode(),fluent.getDiskName(),fluent.getDiskURI(),fluent.getFsType(),fluent.getKind(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}