package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NodeStatusFluent<A extends NodeStatusFluent<A>> extends BaseFluent<A>{
  public NodeStatusFluent() {
  }
  
  public NodeStatusFluent(NodeStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<NodeAddressBuilder> addresses = new ArrayList<NodeAddressBuilder>();
  private Map<String,Quantity> allocatable;
  private Map<String,Quantity> capacity;
  private ArrayList<NodeConditionBuilder> conditions = new ArrayList<NodeConditionBuilder>();
  private NodeConfigStatusBuilder config;
  private NodeDaemonEndpointsBuilder daemonEndpoints;
  private NodeFeaturesBuilder features;
  private ArrayList<ContainerImageBuilder> images = new ArrayList<ContainerImageBuilder>();
  private NodeSystemInfoBuilder nodeInfo;
  private String phase;
  private ArrayList<NodeRuntimeHandlerBuilder> runtimeHandlers = new ArrayList<NodeRuntimeHandlerBuilder>();
  private ArrayList<AttachedVolumeBuilder> volumesAttached = new ArrayList<AttachedVolumeBuilder>();
  private List<String> volumesInUse = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NodeStatus instance) {
    instance = (instance != null ? instance : new NodeStatus());
    if (instance != null) {
          this.withAddresses(instance.getAddresses());
          this.withAllocatable(instance.getAllocatable());
          this.withCapacity(instance.getCapacity());
          this.withConditions(instance.getConditions());
          this.withConfig(instance.getConfig());
          this.withDaemonEndpoints(instance.getDaemonEndpoints());
          this.withFeatures(instance.getFeatures());
          this.withImages(instance.getImages());
          this.withNodeInfo(instance.getNodeInfo());
          this.withPhase(instance.getPhase());
          this.withRuntimeHandlers(instance.getRuntimeHandlers());
          this.withVolumesAttached(instance.getVolumesAttached());
          this.withVolumesInUse(instance.getVolumesInUse());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAddresses(int index,NodeAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<NodeAddressBuilder>();}
    NodeAddressBuilder builder = new NodeAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) {
        _visitables.get("addresses").add(builder);
        addresses.add(builder);
    } else {
        _visitables.get("addresses").add(builder);
        addresses.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToAddresses(int index,NodeAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<NodeAddressBuilder>();}
    NodeAddressBuilder builder = new NodeAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) {
        _visitables.get("addresses").add(builder);
        addresses.add(builder);
    } else {
        _visitables.get("addresses").add(builder);
        addresses.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<NodeAddressBuilder>();}
    for (NodeAddress item : items) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  
  public A addAllToAddresses(Collection<NodeAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<NodeAddressBuilder>();}
    for (NodeAddress item : items) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items) {
    if (this.addresses == null) return (A)this;
    for (NodeAddress item : items) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAddresses(Collection<NodeAddress> items) {
    if (this.addresses == null) return (A)this;
    for (NodeAddress item : items) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAddresses(Predicate<NodeAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<NodeAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      NodeAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NodeAddress> buildAddresses() {
    return this.addresses != null ? build(addresses) : null;
  }
  
  public NodeAddress buildAddress(int index) {
    return this.addresses.get(index).build();
  }
  
  public NodeAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  
  public NodeAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  
  public NodeAddress buildMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
      for (NodeAddressBuilder item : addresses) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
      for (NodeAddressBuilder item : addresses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAddresses(List<NodeAddress> addresses) {
    if (this.addresses != null) {
      this._visitables.get("addresses").clear();
    }
    if (addresses != null) {
        this.addresses = new ArrayList();
        for (NodeAddress item : addresses) {
          this.addToAddresses(item);
        }
    } else {
      this.addresses = null;
    }
    return (A) this;
  }
  
  public A withAddresses(io.fabric8.kubernetes.api.model.NodeAddress... addresses) {
    if (this.addresses != null) {
        this.addresses.clear();
        _visitables.remove("addresses");
    }
    if (addresses != null) {
      for (NodeAddress item : addresses) {
        this.addToAddresses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAddresses() {
    return this.addresses != null && !this.addresses.isEmpty();
  }
  
  public A addNewAddress(String address,String type) {
    return (A)addToAddresses(new NodeAddress(address, type));
  }
  
  public AddressesNested<A> addNewAddress() {
    return new AddressesNested(-1, null);
  }
  
  public AddressesNested<A> addNewAddressLike(NodeAddress item) {
    return new AddressesNested(-1, item);
  }
  
  public AddressesNested<A> setNewAddressLike(int index,NodeAddress item) {
    return new AddressesNested(index, item);
  }
  
  public AddressesNested<A> editAddress(int index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  
  public AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public AddressesNested<A> editMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public A addToAllocatable(String key,Quantity value) {
    if(this.allocatable == null && key != null && value != null) { this.allocatable = new LinkedHashMap(); }
    if(key != null && value != null) {this.allocatable.put(key, value);} return (A)this;
  }
  
  public A addToAllocatable(Map<String,Quantity> map) {
    if(this.allocatable == null && map != null) { this.allocatable = new LinkedHashMap(); }
    if(map != null) { this.allocatable.putAll(map);} return (A)this;
  }
  
  public A removeFromAllocatable(String key) {
    if(this.allocatable == null) { return (A) this; }
    if(key != null && this.allocatable != null) {this.allocatable.remove(key);} return (A)this;
  }
  
  public A removeFromAllocatable(Map<String,Quantity> map) {
    if(this.allocatable == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.allocatable != null){this.allocatable.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getAllocatable() {
    return this.allocatable;
  }
  
  public <K,V>A withAllocatable(Map<String,Quantity> allocatable) {
    if (allocatable == null) {
      this.allocatable = null;
    } else {
      this.allocatable = new LinkedHashMap(allocatable);
    }
    return (A) this;
  }
  
  public boolean hasAllocatable() {
    return this.allocatable != null;
  }
  
  public A addToCapacity(String key,Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  
  public A addToCapacity(Map<String,Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  
  public A removeFromCapacity(String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  
  public A removeFromCapacity(Map<String,Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getCapacity() {
    return this.capacity;
  }
  
  public <K,V>A withCapacity(Map<String,Quantity> capacity) {
    if (capacity == null) {
      this.capacity = null;
    } else {
      this.capacity = new LinkedHashMap(capacity);
    }
    return (A) this;
  }
  
  public boolean hasCapacity() {
    return this.capacity != null;
  }
  
  public A addToConditions(int index,NodeCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<NodeConditionBuilder>();}
    NodeConditionBuilder builder = new NodeConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConditions(int index,NodeCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<NodeConditionBuilder>();}
    NodeConditionBuilder builder = new NodeConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.NodeCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<NodeConditionBuilder>();}
    for (NodeCondition item : items) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<NodeCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<NodeConditionBuilder>();}
    for (NodeCondition item : items) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.NodeCondition... items) {
    if (this.conditions == null) return (A)this;
    for (NodeCondition item : items) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<NodeCondition> items) {
    if (this.conditions == null) return (A)this;
    for (NodeCondition item : items) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<NodeConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<NodeConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      NodeConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NodeCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public NodeCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public NodeCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public NodeCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public NodeCondition buildMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
      for (NodeConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
      for (NodeConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<NodeCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (NodeCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.NodeCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (NodeCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(NodeCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,NodeCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public NodeConfigStatus buildConfig() {
    return this.config != null ? this.config.build() : null;
  }
  
  public A withConfig(NodeConfigStatus config) {
    this._visitables.remove("config");
    if (config != null) {
        this.config = new NodeConfigStatusBuilder(config);
        this._visitables.get("config").add(this.config);
    } else {
        this.config = null;
        this._visitables.get("config").remove(this.config);
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public ConfigNested<A> withNewConfig() {
    return new ConfigNested(null);
  }
  
  public ConfigNested<A> withNewConfigLike(NodeConfigStatus item) {
    return new ConfigNested(item);
  }
  
  public ConfigNested<A> editConfig() {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(null));
  }
  
  public ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(new NodeConfigStatusBuilder().build()));
  }
  
  public ConfigNested<A> editOrNewConfigLike(NodeConfigStatus item) {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(item));
  }
  
  public NodeDaemonEndpoints buildDaemonEndpoints() {
    return this.daemonEndpoints != null ? this.daemonEndpoints.build() : null;
  }
  
  public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints) {
    this._visitables.remove("daemonEndpoints");
    if (daemonEndpoints != null) {
        this.daemonEndpoints = new NodeDaemonEndpointsBuilder(daemonEndpoints);
        this._visitables.get("daemonEndpoints").add(this.daemonEndpoints);
    } else {
        this.daemonEndpoints = null;
        this._visitables.get("daemonEndpoints").remove(this.daemonEndpoints);
    }
    return (A) this;
  }
  
  public boolean hasDaemonEndpoints() {
    return this.daemonEndpoints != null;
  }
  
  public DaemonEndpointsNested<A> withNewDaemonEndpoints() {
    return new DaemonEndpointsNested(null);
  }
  
  public DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
    return new DaemonEndpointsNested(item);
  }
  
  public DaemonEndpointsNested<A> editDaemonEndpoints() {
    return withNewDaemonEndpointsLike(java.util.Optional.ofNullable(buildDaemonEndpoints()).orElse(null));
  }
  
  public DaemonEndpointsNested<A> editOrNewDaemonEndpoints() {
    return withNewDaemonEndpointsLike(java.util.Optional.ofNullable(buildDaemonEndpoints()).orElse(new NodeDaemonEndpointsBuilder().build()));
  }
  
  public DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
    return withNewDaemonEndpointsLike(java.util.Optional.ofNullable(buildDaemonEndpoints()).orElse(item));
  }
  
  public NodeFeatures buildFeatures() {
    return this.features != null ? this.features.build() : null;
  }
  
  public A withFeatures(NodeFeatures features) {
    this._visitables.remove("features");
    if (features != null) {
        this.features = new NodeFeaturesBuilder(features);
        this._visitables.get("features").add(this.features);
    } else {
        this.features = null;
        this._visitables.get("features").remove(this.features);
    }
    return (A) this;
  }
  
  public boolean hasFeatures() {
    return this.features != null;
  }
  
  public A withNewFeatures(Boolean supplementalGroupsPolicy) {
    return (A)withFeatures(new NodeFeatures(supplementalGroupsPolicy));
  }
  
  public FeaturesNested<A> withNewFeatures() {
    return new FeaturesNested(null);
  }
  
  public FeaturesNested<A> withNewFeaturesLike(NodeFeatures item) {
    return new FeaturesNested(item);
  }
  
  public FeaturesNested<A> editFeatures() {
    return withNewFeaturesLike(java.util.Optional.ofNullable(buildFeatures()).orElse(null));
  }
  
  public FeaturesNested<A> editOrNewFeatures() {
    return withNewFeaturesLike(java.util.Optional.ofNullable(buildFeatures()).orElse(new NodeFeaturesBuilder().build()));
  }
  
  public FeaturesNested<A> editOrNewFeaturesLike(NodeFeatures item) {
    return withNewFeaturesLike(java.util.Optional.ofNullable(buildFeatures()).orElse(item));
  }
  
  public A addToImages(int index,ContainerImage item) {
    if (this.images == null) {this.images = new ArrayList<ContainerImageBuilder>();}
    ContainerImageBuilder builder = new ContainerImageBuilder(item);
    if (index < 0 || index >= images.size()) {
        _visitables.get("images").add(builder);
        images.add(builder);
    } else {
        _visitables.get("images").add(builder);
        images.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToImages(int index,ContainerImage item) {
    if (this.images == null) {this.images = new ArrayList<ContainerImageBuilder>();}
    ContainerImageBuilder builder = new ContainerImageBuilder(item);
    if (index < 0 || index >= images.size()) {
        _visitables.get("images").add(builder);
        images.add(builder);
    } else {
        _visitables.get("images").add(builder);
        images.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToImages(io.fabric8.kubernetes.api.model.ContainerImage... items) {
    if (this.images == null) {this.images = new ArrayList<ContainerImageBuilder>();}
    for (ContainerImage item : items) {ContainerImageBuilder builder = new ContainerImageBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  
  public A addAllToImages(Collection<ContainerImage> items) {
    if (this.images == null) {this.images = new ArrayList<ContainerImageBuilder>();}
    for (ContainerImage item : items) {ContainerImageBuilder builder = new ContainerImageBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  
  public A removeFromImages(io.fabric8.kubernetes.api.model.ContainerImage... items) {
    if (this.images == null) return (A)this;
    for (ContainerImage item : items) {ContainerImageBuilder builder = new ContainerImageBuilder(item);_visitables.get("images").remove(builder); this.images.remove(builder);} return (A)this;
  }
  
  public A removeAllFromImages(Collection<ContainerImage> items) {
    if (this.images == null) return (A)this;
    for (ContainerImage item : items) {ContainerImageBuilder builder = new ContainerImageBuilder(item);_visitables.get("images").remove(builder); this.images.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromImages(Predicate<ContainerImageBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<ContainerImageBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      ContainerImageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ContainerImage> buildImages() {
    return this.images != null ? build(images) : null;
  }
  
  public ContainerImage buildImage(int index) {
    return this.images.get(index).build();
  }
  
  public ContainerImage buildFirstImage() {
    return this.images.get(0).build();
  }
  
  public ContainerImage buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  
  public ContainerImage buildMatchingImage(Predicate<ContainerImageBuilder> predicate) {
      for (ContainerImageBuilder item : images) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingImage(Predicate<ContainerImageBuilder> predicate) {
      for (ContainerImageBuilder item : images) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withImages(List<ContainerImage> images) {
    if (this.images != null) {
      this._visitables.get("images").clear();
    }
    if (images != null) {
        this.images = new ArrayList();
        for (ContainerImage item : images) {
          this.addToImages(item);
        }
    } else {
      this.images = null;
    }
    return (A) this;
  }
  
  public A withImages(io.fabric8.kubernetes.api.model.ContainerImage... images) {
    if (this.images != null) {
        this.images.clear();
        _visitables.remove("images");
    }
    if (images != null) {
      for (ContainerImage item : images) {
        this.addToImages(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasImages() {
    return this.images != null && !this.images.isEmpty();
  }
  
  public ImagesNested<A> addNewImage() {
    return new ImagesNested(-1, null);
  }
  
  public ImagesNested<A> addNewImageLike(ContainerImage item) {
    return new ImagesNested(-1, item);
  }
  
  public ImagesNested<A> setNewImageLike(int index,ContainerImage item) {
    return new ImagesNested(index, item);
  }
  
  public ImagesNested<A> editImage(int index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  
  public ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public ImagesNested<A> editMatchingImage(Predicate<ContainerImageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public NodeSystemInfo buildNodeInfo() {
    return this.nodeInfo != null ? this.nodeInfo.build() : null;
  }
  
  public A withNodeInfo(NodeSystemInfo nodeInfo) {
    this._visitables.remove("nodeInfo");
    if (nodeInfo != null) {
        this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
        this._visitables.get("nodeInfo").add(this.nodeInfo);
    } else {
        this.nodeInfo = null;
        this._visitables.get("nodeInfo").remove(this.nodeInfo);
    }
    return (A) this;
  }
  
  public boolean hasNodeInfo() {
    return this.nodeInfo != null;
  }
  
  public NodeInfoNested<A> withNewNodeInfo() {
    return new NodeInfoNested(null);
  }
  
  public NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item) {
    return new NodeInfoNested(item);
  }
  
  public NodeInfoNested<A> editNodeInfo() {
    return withNewNodeInfoLike(java.util.Optional.ofNullable(buildNodeInfo()).orElse(null));
  }
  
  public NodeInfoNested<A> editOrNewNodeInfo() {
    return withNewNodeInfoLike(java.util.Optional.ofNullable(buildNodeInfo()).orElse(new NodeSystemInfoBuilder().build()));
  }
  
  public NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item) {
    return withNewNodeInfoLike(java.util.Optional.ofNullable(buildNodeInfo()).orElse(item));
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase = phase;
    return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public A addToRuntimeHandlers(int index,NodeRuntimeHandler item) {
    if (this.runtimeHandlers == null) {this.runtimeHandlers = new ArrayList<NodeRuntimeHandlerBuilder>();}
    NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);
    if (index < 0 || index >= runtimeHandlers.size()) {
        _visitables.get("runtimeHandlers").add(builder);
        runtimeHandlers.add(builder);
    } else {
        _visitables.get("runtimeHandlers").add(builder);
        runtimeHandlers.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRuntimeHandlers(int index,NodeRuntimeHandler item) {
    if (this.runtimeHandlers == null) {this.runtimeHandlers = new ArrayList<NodeRuntimeHandlerBuilder>();}
    NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);
    if (index < 0 || index >= runtimeHandlers.size()) {
        _visitables.get("runtimeHandlers").add(builder);
        runtimeHandlers.add(builder);
    } else {
        _visitables.get("runtimeHandlers").add(builder);
        runtimeHandlers.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRuntimeHandlers(io.fabric8.kubernetes.api.model.NodeRuntimeHandler... items) {
    if (this.runtimeHandlers == null) {this.runtimeHandlers = new ArrayList<NodeRuntimeHandlerBuilder>();}
    for (NodeRuntimeHandler item : items) {NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);_visitables.get("runtimeHandlers").add(builder);this.runtimeHandlers.add(builder);} return (A)this;
  }
  
  public A addAllToRuntimeHandlers(Collection<NodeRuntimeHandler> items) {
    if (this.runtimeHandlers == null) {this.runtimeHandlers = new ArrayList<NodeRuntimeHandlerBuilder>();}
    for (NodeRuntimeHandler item : items) {NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);_visitables.get("runtimeHandlers").add(builder);this.runtimeHandlers.add(builder);} return (A)this;
  }
  
  public A removeFromRuntimeHandlers(io.fabric8.kubernetes.api.model.NodeRuntimeHandler... items) {
    if (this.runtimeHandlers == null) return (A)this;
    for (NodeRuntimeHandler item : items) {NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);_visitables.get("runtimeHandlers").remove(builder); this.runtimeHandlers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRuntimeHandlers(Collection<NodeRuntimeHandler> items) {
    if (this.runtimeHandlers == null) return (A)this;
    for (NodeRuntimeHandler item : items) {NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);_visitables.get("runtimeHandlers").remove(builder); this.runtimeHandlers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRuntimeHandlers(Predicate<NodeRuntimeHandlerBuilder> predicate) {
    if (runtimeHandlers == null) return (A) this;
    final Iterator<NodeRuntimeHandlerBuilder> each = runtimeHandlers.iterator();
    final List visitables = _visitables.get("runtimeHandlers");
    while (each.hasNext()) {
      NodeRuntimeHandlerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NodeRuntimeHandler> buildRuntimeHandlers() {
    return this.runtimeHandlers != null ? build(runtimeHandlers) : null;
  }
  
  public NodeRuntimeHandler buildRuntimeHandler(int index) {
    return this.runtimeHandlers.get(index).build();
  }
  
  public NodeRuntimeHandler buildFirstRuntimeHandler() {
    return this.runtimeHandlers.get(0).build();
  }
  
  public NodeRuntimeHandler buildLastRuntimeHandler() {
    return this.runtimeHandlers.get(runtimeHandlers.size() - 1).build();
  }
  
  public NodeRuntimeHandler buildMatchingRuntimeHandler(Predicate<NodeRuntimeHandlerBuilder> predicate) {
      for (NodeRuntimeHandlerBuilder item : runtimeHandlers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRuntimeHandler(Predicate<NodeRuntimeHandlerBuilder> predicate) {
      for (NodeRuntimeHandlerBuilder item : runtimeHandlers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRuntimeHandlers(List<NodeRuntimeHandler> runtimeHandlers) {
    if (this.runtimeHandlers != null) {
      this._visitables.get("runtimeHandlers").clear();
    }
    if (runtimeHandlers != null) {
        this.runtimeHandlers = new ArrayList();
        for (NodeRuntimeHandler item : runtimeHandlers) {
          this.addToRuntimeHandlers(item);
        }
    } else {
      this.runtimeHandlers = null;
    }
    return (A) this;
  }
  
  public A withRuntimeHandlers(io.fabric8.kubernetes.api.model.NodeRuntimeHandler... runtimeHandlers) {
    if (this.runtimeHandlers != null) {
        this.runtimeHandlers.clear();
        _visitables.remove("runtimeHandlers");
    }
    if (runtimeHandlers != null) {
      for (NodeRuntimeHandler item : runtimeHandlers) {
        this.addToRuntimeHandlers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRuntimeHandlers() {
    return this.runtimeHandlers != null && !this.runtimeHandlers.isEmpty();
  }
  
  public RuntimeHandlersNested<A> addNewRuntimeHandler() {
    return new RuntimeHandlersNested(-1, null);
  }
  
  public RuntimeHandlersNested<A> addNewRuntimeHandlerLike(NodeRuntimeHandler item) {
    return new RuntimeHandlersNested(-1, item);
  }
  
  public RuntimeHandlersNested<A> setNewRuntimeHandlerLike(int index,NodeRuntimeHandler item) {
    return new RuntimeHandlersNested(index, item);
  }
  
  public RuntimeHandlersNested<A> editRuntimeHandler(int index) {
    if (runtimeHandlers.size() <= index) throw new RuntimeException("Can't edit runtimeHandlers. Index exceeds size.");
    return setNewRuntimeHandlerLike(index, buildRuntimeHandler(index));
  }
  
  public RuntimeHandlersNested<A> editFirstRuntimeHandler() {
    if (runtimeHandlers.size() == 0) throw new RuntimeException("Can't edit first runtimeHandlers. The list is empty.");
    return setNewRuntimeHandlerLike(0, buildRuntimeHandler(0));
  }
  
  public RuntimeHandlersNested<A> editLastRuntimeHandler() {
    int index = runtimeHandlers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last runtimeHandlers. The list is empty.");
    return setNewRuntimeHandlerLike(index, buildRuntimeHandler(index));
  }
  
  public RuntimeHandlersNested<A> editMatchingRuntimeHandler(Predicate<NodeRuntimeHandlerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<runtimeHandlers.size();i++) { 
    if (predicate.test(runtimeHandlers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching runtimeHandlers. No match found.");
    return setNewRuntimeHandlerLike(index, buildRuntimeHandler(index));
  }
  
  public A addToVolumesAttached(int index,AttachedVolume item) {
    if (this.volumesAttached == null) {this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();}
    AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
    if (index < 0 || index >= volumesAttached.size()) {
        _visitables.get("volumesAttached").add(builder);
        volumesAttached.add(builder);
    } else {
        _visitables.get("volumesAttached").add(builder);
        volumesAttached.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToVolumesAttached(int index,AttachedVolume item) {
    if (this.volumesAttached == null) {this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();}
    AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
    if (index < 0 || index >= volumesAttached.size()) {
        _visitables.get("volumesAttached").add(builder);
        volumesAttached.add(builder);
    } else {
        _visitables.get("volumesAttached").add(builder);
        volumesAttached.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... items) {
    if (this.volumesAttached == null) {this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();}
    for (AttachedVolume item : items) {AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);_visitables.get("volumesAttached").add(builder);this.volumesAttached.add(builder);} return (A)this;
  }
  
  public A addAllToVolumesAttached(Collection<AttachedVolume> items) {
    if (this.volumesAttached == null) {this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();}
    for (AttachedVolume item : items) {AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);_visitables.get("volumesAttached").add(builder);this.volumesAttached.add(builder);} return (A)this;
  }
  
  public A removeFromVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... items) {
    if (this.volumesAttached == null) return (A)this;
    for (AttachedVolume item : items) {AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);_visitables.get("volumesAttached").remove(builder); this.volumesAttached.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVolumesAttached(Collection<AttachedVolume> items) {
    if (this.volumesAttached == null) return (A)this;
    for (AttachedVolume item : items) {AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);_visitables.get("volumesAttached").remove(builder); this.volumesAttached.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
    if (volumesAttached == null) return (A) this;
    final Iterator<AttachedVolumeBuilder> each = volumesAttached.iterator();
    final List visitables = _visitables.get("volumesAttached");
    while (each.hasNext()) {
      AttachedVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AttachedVolume> buildVolumesAttached() {
    return this.volumesAttached != null ? build(volumesAttached) : null;
  }
  
  public AttachedVolume buildVolumesAttached(int index) {
    return this.volumesAttached.get(index).build();
  }
  
  public AttachedVolume buildFirstVolumesAttached() {
    return this.volumesAttached.get(0).build();
  }
  
  public AttachedVolume buildLastVolumesAttached() {
    return this.volumesAttached.get(volumesAttached.size() - 1).build();
  }
  
  public AttachedVolume buildMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
      for (AttachedVolumeBuilder item : volumesAttached) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
      for (AttachedVolumeBuilder item : volumesAttached) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumesAttached(List<AttachedVolume> volumesAttached) {
    if (this.volumesAttached != null) {
      this._visitables.get("volumesAttached").clear();
    }
    if (volumesAttached != null) {
        this.volumesAttached = new ArrayList();
        for (AttachedVolume item : volumesAttached) {
          this.addToVolumesAttached(item);
        }
    } else {
      this.volumesAttached = null;
    }
    return (A) this;
  }
  
  public A withVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... volumesAttached) {
    if (this.volumesAttached != null) {
        this.volumesAttached.clear();
        _visitables.remove("volumesAttached");
    }
    if (volumesAttached != null) {
      for (AttachedVolume item : volumesAttached) {
        this.addToVolumesAttached(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumesAttached() {
    return this.volumesAttached != null && !this.volumesAttached.isEmpty();
  }
  
  public A addNewVolumesAttached(String devicePath,String name) {
    return (A)addToVolumesAttached(new AttachedVolume(devicePath, name));
  }
  
  public VolumesAttachedNested<A> addNewVolumesAttached() {
    return new VolumesAttachedNested(-1, null);
  }
  
  public VolumesAttachedNested<A> addNewVolumesAttachedLike(AttachedVolume item) {
    return new VolumesAttachedNested(-1, item);
  }
  
  public VolumesAttachedNested<A> setNewVolumesAttachedLike(int index,AttachedVolume item) {
    return new VolumesAttachedNested(index, item);
  }
  
  public VolumesAttachedNested<A> editVolumesAttached(int index) {
    if (volumesAttached.size() <= index) throw new RuntimeException("Can't edit volumesAttached. Index exceeds size.");
    return setNewVolumesAttachedLike(index, buildVolumesAttached(index));
  }
  
  public VolumesAttachedNested<A> editFirstVolumesAttached() {
    if (volumesAttached.size() == 0) throw new RuntimeException("Can't edit first volumesAttached. The list is empty.");
    return setNewVolumesAttachedLike(0, buildVolumesAttached(0));
  }
  
  public VolumesAttachedNested<A> editLastVolumesAttached() {
    int index = volumesAttached.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumesAttached. The list is empty.");
    return setNewVolumesAttachedLike(index, buildVolumesAttached(index));
  }
  
  public VolumesAttachedNested<A> editMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumesAttached.size();i++) { 
    if (predicate.test(volumesAttached.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumesAttached. No match found.");
    return setNewVolumesAttachedLike(index, buildVolumesAttached(index));
  }
  
  public A addToVolumesInUse(int index,String item) {
    if (this.volumesInUse == null) {this.volumesInUse = new ArrayList<String>();}
    this.volumesInUse.add(index, item);
    return (A)this;
  }
  
  public A setToVolumesInUse(int index,String item) {
    if (this.volumesInUse == null) {this.volumesInUse = new ArrayList<String>();}
    this.volumesInUse.set(index, item); return (A)this;
  }
  
  public A addToVolumesInUse(java.lang.String... items) {
    if (this.volumesInUse == null) {this.volumesInUse = new ArrayList<String>();}
    for (String item : items) {this.volumesInUse.add(item);} return (A)this;
  }
  
  public A addAllToVolumesInUse(Collection<String> items) {
    if (this.volumesInUse == null) {this.volumesInUse = new ArrayList<String>();}
    for (String item : items) {this.volumesInUse.add(item);} return (A)this;
  }
  
  public A removeFromVolumesInUse(java.lang.String... items) {
    if (this.volumesInUse == null) return (A)this;
    for (String item : items) { this.volumesInUse.remove(item);} return (A)this;
  }
  
  public A removeAllFromVolumesInUse(Collection<String> items) {
    if (this.volumesInUse == null) return (A)this;
    for (String item : items) { this.volumesInUse.remove(item);} return (A)this;
  }
  
  public List<String> getVolumesInUse() {
    return this.volumesInUse;
  }
  
  public String getVolumesInUse(int index) {
    return this.volumesInUse.get(index);
  }
  
  public String getFirstVolumesInUse() {
    return this.volumesInUse.get(0);
  }
  
  public String getLastVolumesInUse() {
    return this.volumesInUse.get(volumesInUse.size() - 1);
  }
  
  public String getMatchingVolumesInUse(Predicate<String> predicate) {
      for (String item : volumesInUse) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumesInUse(Predicate<String> predicate) {
      for (String item : volumesInUse) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumesInUse(List<String> volumesInUse) {
    if (volumesInUse != null) {
        this.volumesInUse = new ArrayList();
        for (String item : volumesInUse) {
          this.addToVolumesInUse(item);
        }
    } else {
      this.volumesInUse = null;
    }
    return (A) this;
  }
  
  public A withVolumesInUse(java.lang.String... volumesInUse) {
    if (this.volumesInUse != null) {
        this.volumesInUse.clear();
        _visitables.remove("volumesInUse");
    }
    if (volumesInUse != null) {
      for (String item : volumesInUse) {
        this.addToVolumesInUse(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumesInUse() {
    return this.volumesInUse != null && !this.volumesInUse.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeStatusFluent that = (NodeStatusFluent) o;
    if (!java.util.Objects.equals(addresses, that.addresses)) return false;
    if (!java.util.Objects.equals(allocatable, that.allocatable)) return false;
    if (!java.util.Objects.equals(capacity, that.capacity)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    if (!java.util.Objects.equals(daemonEndpoints, that.daemonEndpoints)) return false;
    if (!java.util.Objects.equals(features, that.features)) return false;
    if (!java.util.Objects.equals(images, that.images)) return false;
    if (!java.util.Objects.equals(nodeInfo, that.nodeInfo)) return false;
    if (!java.util.Objects.equals(phase, that.phase)) return false;
    if (!java.util.Objects.equals(runtimeHandlers, that.runtimeHandlers)) return false;
    if (!java.util.Objects.equals(volumesAttached, that.volumesAttached)) return false;
    if (!java.util.Objects.equals(volumesInUse, that.volumesInUse)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(addresses,  allocatable,  capacity,  conditions,  config,  daemonEndpoints,  features,  images,  nodeInfo,  phase,  runtimeHandlers,  volumesAttached,  volumesInUse,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (allocatable != null && !allocatable.isEmpty()) { sb.append("allocatable:"); sb.append(allocatable + ","); }
    if (capacity != null && !capacity.isEmpty()) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (config != null) { sb.append("config:"); sb.append(config + ","); }
    if (daemonEndpoints != null) { sb.append("daemonEndpoints:"); sb.append(daemonEndpoints + ","); }
    if (features != null) { sb.append("features:"); sb.append(features + ","); }
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (nodeInfo != null) { sb.append("nodeInfo:"); sb.append(nodeInfo + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (runtimeHandlers != null && !runtimeHandlers.isEmpty()) { sb.append("runtimeHandlers:"); sb.append(runtimeHandlers + ","); }
    if (volumesAttached != null && !volumesAttached.isEmpty()) { sb.append("volumesAttached:"); sb.append(volumesAttached + ","); }
    if (volumesInUse != null && !volumesInUse.isEmpty()) { sb.append("volumesInUse:"); sb.append(volumesInUse + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AddressesNested<N> extends NodeAddressFluent<AddressesNested<N>> implements Nested<N>{
    AddressesNested(int index,NodeAddress item) {
      this.index = index;
      this.builder = new NodeAddressBuilder(this, item);
    }
    NodeAddressBuilder builder;
    int index;
    
    public N and() {
      return (N) NodeStatusFluent.this.setToAddresses(index,builder.build());
    }
    
    public N endAddress() {
      return and();
    }
    
  
  }
  public class ConditionsNested<N> extends NodeConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,NodeCondition item) {
      this.index = index;
      this.builder = new NodeConditionBuilder(this, item);
    }
    NodeConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) NodeStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class ConfigNested<N> extends NodeConfigStatusFluent<ConfigNested<N>> implements Nested<N>{
    ConfigNested(NodeConfigStatus item) {
      this.builder = new NodeConfigStatusBuilder(this, item);
    }
    NodeConfigStatusBuilder builder;
    
    public N and() {
      return (N) NodeStatusFluent.this.withConfig(builder.build());
    }
    
    public N endConfig() {
      return and();
    }
    
  
  }
  public class DaemonEndpointsNested<N> extends NodeDaemonEndpointsFluent<DaemonEndpointsNested<N>> implements Nested<N>{
    DaemonEndpointsNested(NodeDaemonEndpoints item) {
      this.builder = new NodeDaemonEndpointsBuilder(this, item);
    }
    NodeDaemonEndpointsBuilder builder;
    
    public N and() {
      return (N) NodeStatusFluent.this.withDaemonEndpoints(builder.build());
    }
    
    public N endDaemonEndpoints() {
      return and();
    }
    
  
  }
  public class FeaturesNested<N> extends NodeFeaturesFluent<FeaturesNested<N>> implements Nested<N>{
    FeaturesNested(NodeFeatures item) {
      this.builder = new NodeFeaturesBuilder(this, item);
    }
    NodeFeaturesBuilder builder;
    
    public N and() {
      return (N) NodeStatusFluent.this.withFeatures(builder.build());
    }
    
    public N endFeatures() {
      return and();
    }
    
  
  }
  public class ImagesNested<N> extends ContainerImageFluent<ImagesNested<N>> implements Nested<N>{
    ImagesNested(int index,ContainerImage item) {
      this.index = index;
      this.builder = new ContainerImageBuilder(this, item);
    }
    ContainerImageBuilder builder;
    int index;
    
    public N and() {
      return (N) NodeStatusFluent.this.setToImages(index,builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class NodeInfoNested<N> extends NodeSystemInfoFluent<NodeInfoNested<N>> implements Nested<N>{
    NodeInfoNested(NodeSystemInfo item) {
      this.builder = new NodeSystemInfoBuilder(this, item);
    }
    NodeSystemInfoBuilder builder;
    
    public N and() {
      return (N) NodeStatusFluent.this.withNodeInfo(builder.build());
    }
    
    public N endNodeInfo() {
      return and();
    }
    
  
  }
  public class RuntimeHandlersNested<N> extends NodeRuntimeHandlerFluent<RuntimeHandlersNested<N>> implements Nested<N>{
    RuntimeHandlersNested(int index,NodeRuntimeHandler item) {
      this.index = index;
      this.builder = new NodeRuntimeHandlerBuilder(this, item);
    }
    NodeRuntimeHandlerBuilder builder;
    int index;
    
    public N and() {
      return (N) NodeStatusFluent.this.setToRuntimeHandlers(index,builder.build());
    }
    
    public N endRuntimeHandler() {
      return and();
    }
    
  
  }
  public class VolumesAttachedNested<N> extends AttachedVolumeFluent<VolumesAttachedNested<N>> implements Nested<N>{
    VolumesAttachedNested(int index,AttachedVolume item) {
      this.index = index;
      this.builder = new AttachedVolumeBuilder(this, item);
    }
    AttachedVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) NodeStatusFluent.this.setToVolumesAttached(index,builder.build());
    }
    
    public N endVolumesAttached() {
      return and();
    }
    
  
  }

}