package io.fabric8.kubernetes.api.model.version;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class InfoFluent<A extends InfoFluent<A>> extends BaseFluent<A>{
  public InfoFluent() {
  }
  
  public InfoFluent(Info instance) {
    this.copyInstance(instance);
  }
  private String buildDate;
  private String compiler;
  private String emulationMajor;
  private String emulationMinor;
  private String gitCommit;
  private String gitTreeState;
  private String gitVersion;
  private String goVersion;
  private String major;
  private String minCompatibilityMajor;
  private String minCompatibilityMinor;
  private String minor;
  private String platform;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Info instance) {
    instance = (instance != null ? instance : new Info());
    if (instance != null) {
          this.withBuildDate(instance.getBuildDate());
          this.withCompiler(instance.getCompiler());
          this.withEmulationMajor(instance.getEmulationMajor());
          this.withEmulationMinor(instance.getEmulationMinor());
          this.withGitCommit(instance.getGitCommit());
          this.withGitTreeState(instance.getGitTreeState());
          this.withGitVersion(instance.getGitVersion());
          this.withGoVersion(instance.getGoVersion());
          this.withMajor(instance.getMajor());
          this.withMinCompatibilityMajor(instance.getMinCompatibilityMajor());
          this.withMinCompatibilityMinor(instance.getMinCompatibilityMinor());
          this.withMinor(instance.getMinor());
          this.withPlatform(instance.getPlatform());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBuildDate() {
    return this.buildDate;
  }
  
  public A withBuildDate(String buildDate) {
    this.buildDate = buildDate;
    return (A) this;
  }
  
  public boolean hasBuildDate() {
    return this.buildDate != null;
  }
  
  public String getCompiler() {
    return this.compiler;
  }
  
  public A withCompiler(String compiler) {
    this.compiler = compiler;
    return (A) this;
  }
  
  public boolean hasCompiler() {
    return this.compiler != null;
  }
  
  public String getEmulationMajor() {
    return this.emulationMajor;
  }
  
  public A withEmulationMajor(String emulationMajor) {
    this.emulationMajor = emulationMajor;
    return (A) this;
  }
  
  public boolean hasEmulationMajor() {
    return this.emulationMajor != null;
  }
  
  public String getEmulationMinor() {
    return this.emulationMinor;
  }
  
  public A withEmulationMinor(String emulationMinor) {
    this.emulationMinor = emulationMinor;
    return (A) this;
  }
  
  public boolean hasEmulationMinor() {
    return this.emulationMinor != null;
  }
  
  public String getGitCommit() {
    return this.gitCommit;
  }
  
  public A withGitCommit(String gitCommit) {
    this.gitCommit = gitCommit;
    return (A) this;
  }
  
  public boolean hasGitCommit() {
    return this.gitCommit != null;
  }
  
  public String getGitTreeState() {
    return this.gitTreeState;
  }
  
  public A withGitTreeState(String gitTreeState) {
    this.gitTreeState = gitTreeState;
    return (A) this;
  }
  
  public boolean hasGitTreeState() {
    return this.gitTreeState != null;
  }
  
  public String getGitVersion() {
    return this.gitVersion;
  }
  
  public A withGitVersion(String gitVersion) {
    this.gitVersion = gitVersion;
    return (A) this;
  }
  
  public boolean hasGitVersion() {
    return this.gitVersion != null;
  }
  
  public String getGoVersion() {
    return this.goVersion;
  }
  
  public A withGoVersion(String goVersion) {
    this.goVersion = goVersion;
    return (A) this;
  }
  
  public boolean hasGoVersion() {
    return this.goVersion != null;
  }
  
  public String getMajor() {
    return this.major;
  }
  
  public A withMajor(String major) {
    this.major = major;
    return (A) this;
  }
  
  public boolean hasMajor() {
    return this.major != null;
  }
  
  public String getMinCompatibilityMajor() {
    return this.minCompatibilityMajor;
  }
  
  public A withMinCompatibilityMajor(String minCompatibilityMajor) {
    this.minCompatibilityMajor = minCompatibilityMajor;
    return (A) this;
  }
  
  public boolean hasMinCompatibilityMajor() {
    return this.minCompatibilityMajor != null;
  }
  
  public String getMinCompatibilityMinor() {
    return this.minCompatibilityMinor;
  }
  
  public A withMinCompatibilityMinor(String minCompatibilityMinor) {
    this.minCompatibilityMinor = minCompatibilityMinor;
    return (A) this;
  }
  
  public boolean hasMinCompatibilityMinor() {
    return this.minCompatibilityMinor != null;
  }
  
  public String getMinor() {
    return this.minor;
  }
  
  public A withMinor(String minor) {
    this.minor = minor;
    return (A) this;
  }
  
  public boolean hasMinor() {
    return this.minor != null;
  }
  
  public String getPlatform() {
    return this.platform;
  }
  
  public A withPlatform(String platform) {
    this.platform = platform;
    return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InfoFluent that = (InfoFluent) o;
    if (!java.util.Objects.equals(buildDate, that.buildDate)) return false;
    if (!java.util.Objects.equals(compiler, that.compiler)) return false;
    if (!java.util.Objects.equals(emulationMajor, that.emulationMajor)) return false;
    if (!java.util.Objects.equals(emulationMinor, that.emulationMinor)) return false;
    if (!java.util.Objects.equals(gitCommit, that.gitCommit)) return false;
    if (!java.util.Objects.equals(gitTreeState, that.gitTreeState)) return false;
    if (!java.util.Objects.equals(gitVersion, that.gitVersion)) return false;
    if (!java.util.Objects.equals(goVersion, that.goVersion)) return false;
    if (!java.util.Objects.equals(major, that.major)) return false;
    if (!java.util.Objects.equals(minCompatibilityMajor, that.minCompatibilityMajor)) return false;
    if (!java.util.Objects.equals(minCompatibilityMinor, that.minCompatibilityMinor)) return false;
    if (!java.util.Objects.equals(minor, that.minor)) return false;
    if (!java.util.Objects.equals(platform, that.platform)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(buildDate,  compiler,  emulationMajor,  emulationMinor,  gitCommit,  gitTreeState,  gitVersion,  goVersion,  major,  minCompatibilityMajor,  minCompatibilityMinor,  minor,  platform,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildDate != null) { sb.append("buildDate:"); sb.append(buildDate + ","); }
    if (compiler != null) { sb.append("compiler:"); sb.append(compiler + ","); }
    if (emulationMajor != null) { sb.append("emulationMajor:"); sb.append(emulationMajor + ","); }
    if (emulationMinor != null) { sb.append("emulationMinor:"); sb.append(emulationMinor + ","); }
    if (gitCommit != null) { sb.append("gitCommit:"); sb.append(gitCommit + ","); }
    if (gitTreeState != null) { sb.append("gitTreeState:"); sb.append(gitTreeState + ","); }
    if (gitVersion != null) { sb.append("gitVersion:"); sb.append(gitVersion + ","); }
    if (goVersion != null) { sb.append("goVersion:"); sb.append(goVersion + ","); }
    if (major != null) { sb.append("major:"); sb.append(major + ","); }
    if (minCompatibilityMajor != null) { sb.append("minCompatibilityMajor:"); sb.append(minCompatibilityMajor + ","); }
    if (minCompatibilityMinor != null) { sb.append("minCompatibilityMinor:"); sb.append(minCompatibilityMinor + ","); }
    if (minor != null) { sb.append("minor:"); sb.append(minor + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}