/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.APIGroupBuilder;
import io.fabric8.kubernetes.api.model.GroupVersionForDiscovery;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "name", "preferredVersion", "serverAddressByClientCIDRs", "versions"})
@Version(value="v1")
@Group(value="")
public class APIGroup
implements Editable<APIGroupBuilder>,
KubernetesResource {
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @JsonProperty(value="kind")
    private String kind = "APIGroup";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="preferredVersion")
    private GroupVersionForDiscovery preferredVersion;
    @JsonProperty(value="serverAddressByClientCIDRs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ServerAddressByClientCIDR> serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDR>();
    @JsonProperty(value="versions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<GroupVersionForDiscovery> versions = new ArrayList<GroupVersionForDiscovery>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public APIGroup() {
    }

    public APIGroup(String apiVersion, String kind, String name, GroupVersionForDiscovery preferredVersion, List<ServerAddressByClientCIDR> serverAddressByClientCIDRs, List<GroupVersionForDiscovery> versions) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.name = name;
        this.preferredVersion = preferredVersion;
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
        this.versions = versions;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="preferredVersion")
    public GroupVersionForDiscovery getPreferredVersion() {
        return this.preferredVersion;
    }

    @JsonProperty(value="preferredVersion")
    public void setPreferredVersion(GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
    }

    @JsonProperty(value="serverAddressByClientCIDRs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs;
    }

    @JsonProperty(value="serverAddressByClientCIDRs")
    public void setServerAddressByClientCIDRs(List<ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
    }

    @JsonProperty(value="versions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<GroupVersionForDiscovery> getVersions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    public void setVersions(List<GroupVersionForDiscovery> versions) {
        this.versions = versions;
    }

    @JsonIgnore
    public APIGroupBuilder edit() {
        return new APIGroupBuilder(this);
    }

    @JsonIgnore
    public APIGroupBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "APIGroup(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", name=" + this.getName() + ", preferredVersion=" + String.valueOf(this.getPreferredVersion()) + ", serverAddressByClientCIDRs=" + String.valueOf(this.getServerAddressByClientCIDRs()) + ", versions=" + String.valueOf(this.getVersions()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIGroup)) {
            return false;
        }
        APIGroup other = (APIGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        GroupVersionForDiscovery this$preferredVersion = this.getPreferredVersion();
        GroupVersionForDiscovery other$preferredVersion = other.getPreferredVersion();
        if (this$preferredVersion == null ? other$preferredVersion != null : !((Object)this$preferredVersion).equals(other$preferredVersion)) {
            return false;
        }
        List<ServerAddressByClientCIDR> this$serverAddressByClientCIDRs = this.getServerAddressByClientCIDRs();
        List<ServerAddressByClientCIDR> other$serverAddressByClientCIDRs = other.getServerAddressByClientCIDRs();
        if (this$serverAddressByClientCIDRs == null ? other$serverAddressByClientCIDRs != null : !((Object)this$serverAddressByClientCIDRs).equals(other$serverAddressByClientCIDRs)) {
            return false;
        }
        List<GroupVersionForDiscovery> this$versions = this.getVersions();
        List<GroupVersionForDiscovery> other$versions = other.getVersions();
        if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof APIGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        GroupVersionForDiscovery $preferredVersion = this.getPreferredVersion();
        result = result * 59 + ($preferredVersion == null ? 43 : ((Object)$preferredVersion).hashCode());
        List<ServerAddressByClientCIDR> $serverAddressByClientCIDRs = this.getServerAddressByClientCIDRs();
        result = result * 59 + ($serverAddressByClientCIDRs == null ? 43 : ((Object)$serverAddressByClientCIDRs).hashCode());
        List<GroupVersionForDiscovery> $versions = this.getVersions();
        result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

