package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class APIGroupFluent<A extends APIGroupFluent<A>> extends BaseFluent<A>{
  public APIGroupFluent() {
  }
  
  public APIGroupFluent(APIGroup instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String kind;
  private String name;
  private GroupVersionForDiscoveryBuilder preferredVersion;
  private ArrayList<ServerAddressByClientCIDRBuilder> serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();
  private ArrayList<GroupVersionForDiscoveryBuilder> versions = new ArrayList<GroupVersionForDiscoveryBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(APIGroup instance) {
    instance = (instance != null ? instance : new APIGroup());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withKind(instance.getKind());
          this.withName(instance.getName());
          this.withPreferredVersion(instance.getPreferredVersion());
          this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
          this.withVersions(instance.getVersions());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public GroupVersionForDiscovery buildPreferredVersion() {
    return this.preferredVersion != null ? this.preferredVersion.build() : null;
  }
  
  public A withPreferredVersion(GroupVersionForDiscovery preferredVersion) {
    this._visitables.remove("preferredVersion");
    if (preferredVersion != null) {
        this.preferredVersion = new GroupVersionForDiscoveryBuilder(preferredVersion);
        this._visitables.get("preferredVersion").add(this.preferredVersion);
    } else {
        this.preferredVersion = null;
        this._visitables.get("preferredVersion").remove(this.preferredVersion);
    }
    return (A) this;
  }
  
  public boolean hasPreferredVersion() {
    return this.preferredVersion != null;
  }
  
  public A withNewPreferredVersion(String groupVersion,String version) {
    return (A)withPreferredVersion(new GroupVersionForDiscovery(groupVersion, version));
  }
  
  public PreferredVersionNested<A> withNewPreferredVersion() {
    return new PreferredVersionNested(null);
  }
  
  public PreferredVersionNested<A> withNewPreferredVersionLike(GroupVersionForDiscovery item) {
    return new PreferredVersionNested(item);
  }
  
  public PreferredVersionNested<A> editPreferredVersion() {
    return withNewPreferredVersionLike(java.util.Optional.ofNullable(buildPreferredVersion()).orElse(null));
  }
  
  public PreferredVersionNested<A> editOrNewPreferredVersion() {
    return withNewPreferredVersionLike(java.util.Optional.ofNullable(buildPreferredVersion()).orElse(new GroupVersionForDiscoveryBuilder().build()));
  }
  
  public PreferredVersionNested<A> editOrNewPreferredVersionLike(GroupVersionForDiscovery item) {
    return withNewPreferredVersionLike(java.util.Optional.ofNullable(buildPreferredVersion()).orElse(item));
  }
  
  public A addToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item) {
    if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();}
    ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
    if (index < 0 || index >= serverAddressByClientCIDRs.size()) {
        _visitables.get("serverAddressByClientCIDRs").add(builder);
        serverAddressByClientCIDRs.add(builder);
    } else {
        _visitables.get("serverAddressByClientCIDRs").add(builder);
        serverAddressByClientCIDRs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item) {
    if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();}
    ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
    if (index < 0 || index >= serverAddressByClientCIDRs.size()) {
        _visitables.get("serverAddressByClientCIDRs").add(builder);
        serverAddressByClientCIDRs.add(builder);
    } else {
        _visitables.get("serverAddressByClientCIDRs").add(builder);
        serverAddressByClientCIDRs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... items) {
    if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();}
    for (ServerAddressByClientCIDR item : items) {ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").add(builder);this.serverAddressByClientCIDRs.add(builder);} return (A)this;
  }
  
  public A addAllToServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items) {
    if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();}
    for (ServerAddressByClientCIDR item : items) {ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").add(builder);this.serverAddressByClientCIDRs.add(builder);} return (A)this;
  }
  
  public A removeFromServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... items) {
    if (this.serverAddressByClientCIDRs == null) return (A)this;
    for (ServerAddressByClientCIDR item : items) {ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").remove(builder); this.serverAddressByClientCIDRs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items) {
    if (this.serverAddressByClientCIDRs == null) return (A)this;
    for (ServerAddressByClientCIDR item : items) {ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").remove(builder); this.serverAddressByClientCIDRs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromServerAddressByClientCIDRs(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
    if (serverAddressByClientCIDRs == null) return (A) this;
    final Iterator<ServerAddressByClientCIDRBuilder> each = serverAddressByClientCIDRs.iterator();
    final List visitables = _visitables.get("serverAddressByClientCIDRs");
    while (each.hasNext()) {
      ServerAddressByClientCIDRBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ServerAddressByClientCIDR> buildServerAddressByClientCIDRs() {
    return this.serverAddressByClientCIDRs != null ? build(serverAddressByClientCIDRs) : null;
  }
  
  public ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index) {
    return this.serverAddressByClientCIDRs.get(index).build();
  }
  
  public ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR() {
    return this.serverAddressByClientCIDRs.get(0).build();
  }
  
  public ServerAddressByClientCIDR buildLastServerAddressByClientCIDR() {
    return this.serverAddressByClientCIDRs.get(serverAddressByClientCIDRs.size() - 1).build();
  }
  
  public ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
      for (ServerAddressByClientCIDRBuilder item : serverAddressByClientCIDRs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
      for (ServerAddressByClientCIDRBuilder item : serverAddressByClientCIDRs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServerAddressByClientCIDRs(List<ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
    if (this.serverAddressByClientCIDRs != null) {
      this._visitables.get("serverAddressByClientCIDRs").clear();
    }
    if (serverAddressByClientCIDRs != null) {
        this.serverAddressByClientCIDRs = new ArrayList();
        for (ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
          this.addToServerAddressByClientCIDRs(item);
        }
    } else {
      this.serverAddressByClientCIDRs = null;
    }
    return (A) this;
  }
  
  public A withServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... serverAddressByClientCIDRs) {
    if (this.serverAddressByClientCIDRs != null) {
        this.serverAddressByClientCIDRs.clear();
        _visitables.remove("serverAddressByClientCIDRs");
    }
    if (serverAddressByClientCIDRs != null) {
      for (ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
        this.addToServerAddressByClientCIDRs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServerAddressByClientCIDRs() {
    return this.serverAddressByClientCIDRs != null && !this.serverAddressByClientCIDRs.isEmpty();
  }
  
  public A addNewServerAddressByClientCIDR(String clientCIDR,String serverAddress) {
    return (A)addToServerAddressByClientCIDRs(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
  }
  
  public ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR() {
    return new ServerAddressByClientCIDRsNested(-1, null);
  }
  
  public ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(ServerAddressByClientCIDR item) {
    return new ServerAddressByClientCIDRsNested(-1, item);
  }
  
  public ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index,ServerAddressByClientCIDR item) {
    return new ServerAddressByClientCIDRsNested(index, item);
  }
  
  public ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index) {
    if (serverAddressByClientCIDRs.size() <= index) throw new RuntimeException("Can't edit serverAddressByClientCIDRs. Index exceeds size.");
    return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
  }
  
  public ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR() {
    if (serverAddressByClientCIDRs.size() == 0) throw new RuntimeException("Can't edit first serverAddressByClientCIDRs. The list is empty.");
    return setNewServerAddressByClientCIDRLike(0, buildServerAddressByClientCIDR(0));
  }
  
  public ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR() {
    int index = serverAddressByClientCIDRs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serverAddressByClientCIDRs. The list is empty.");
    return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
  }
  
  public ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serverAddressByClientCIDRs.size();i++) { 
    if (predicate.test(serverAddressByClientCIDRs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serverAddressByClientCIDRs. No match found.");
    return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
  }
  
  public A addToVersions(int index,GroupVersionForDiscovery item) {
    if (this.versions == null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();}
    GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
    if (index < 0 || index >= versions.size()) {
        _visitables.get("versions").add(builder);
        versions.add(builder);
    } else {
        _visitables.get("versions").add(builder);
        versions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToVersions(int index,GroupVersionForDiscovery item) {
    if (this.versions == null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();}
    GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
    if (index < 0 || index >= versions.size()) {
        _visitables.get("versions").add(builder);
        versions.add(builder);
    } else {
        _visitables.get("versions").add(builder);
        versions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... items) {
    if (this.versions == null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();}
    for (GroupVersionForDiscovery item : items) {GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  
  public A addAllToVersions(Collection<GroupVersionForDiscovery> items) {
    if (this.versions == null) {this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();}
    for (GroupVersionForDiscovery item : items) {GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  
  public A removeFromVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... items) {
    if (this.versions == null) return (A)this;
    for (GroupVersionForDiscovery item : items) {GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").remove(builder); this.versions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVersions(Collection<GroupVersionForDiscovery> items) {
    if (this.versions == null) return (A)this;
    for (GroupVersionForDiscovery item : items) {GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").remove(builder); this.versions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVersions(Predicate<GroupVersionForDiscoveryBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<GroupVersionForDiscoveryBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      GroupVersionForDiscoveryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GroupVersionForDiscovery> buildVersions() {
    return this.versions != null ? build(versions) : null;
  }
  
  public GroupVersionForDiscovery buildVersion(int index) {
    return this.versions.get(index).build();
  }
  
  public GroupVersionForDiscovery buildFirstVersion() {
    return this.versions.get(0).build();
  }
  
  public GroupVersionForDiscovery buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  
  public GroupVersionForDiscovery buildMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate) {
      for (GroupVersionForDiscoveryBuilder item : versions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate) {
      for (GroupVersionForDiscoveryBuilder item : versions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVersions(List<GroupVersionForDiscovery> versions) {
    if (this.versions != null) {
      this._visitables.get("versions").clear();
    }
    if (versions != null) {
        this.versions = new ArrayList();
        for (GroupVersionForDiscovery item : versions) {
          this.addToVersions(item);
        }
    } else {
      this.versions = null;
    }
    return (A) this;
  }
  
  public A withVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... versions) {
    if (this.versions != null) {
        this.versions.clear();
        _visitables.remove("versions");
    }
    if (versions != null) {
      for (GroupVersionForDiscovery item : versions) {
        this.addToVersions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVersions() {
    return this.versions != null && !this.versions.isEmpty();
  }
  
  public A addNewVersion(String groupVersion,String version) {
    return (A)addToVersions(new GroupVersionForDiscovery(groupVersion, version));
  }
  
  public VersionsNested<A> addNewVersion() {
    return new VersionsNested(-1, null);
  }
  
  public VersionsNested<A> addNewVersionLike(GroupVersionForDiscovery item) {
    return new VersionsNested(-1, item);
  }
  
  public VersionsNested<A> setNewVersionLike(int index,GroupVersionForDiscovery item) {
    return new VersionsNested(index, item);
  }
  
  public VersionsNested<A> editVersion(int index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  
  public VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  
  public VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  
  public VersionsNested<A> editMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIGroupFluent that = (APIGroupFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(preferredVersion, that.preferredVersion)) return false;
    if (!java.util.Objects.equals(serverAddressByClientCIDRs, that.serverAddressByClientCIDRs)) return false;
    if (!java.util.Objects.equals(versions, that.versions)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  name,  preferredVersion,  serverAddressByClientCIDRs,  versions,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (preferredVersion != null) { sb.append("preferredVersion:"); sb.append(preferredVersion + ","); }
    if (serverAddressByClientCIDRs != null && !serverAddressByClientCIDRs.isEmpty()) { sb.append("serverAddressByClientCIDRs:"); sb.append(serverAddressByClientCIDRs + ","); }
    if (versions != null && !versions.isEmpty()) { sb.append("versions:"); sb.append(versions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PreferredVersionNested<N> extends GroupVersionForDiscoveryFluent<PreferredVersionNested<N>> implements Nested<N>{
    PreferredVersionNested(GroupVersionForDiscovery item) {
      this.builder = new GroupVersionForDiscoveryBuilder(this, item);
    }
    GroupVersionForDiscoveryBuilder builder;
    
    public N and() {
      return (N) APIGroupFluent.this.withPreferredVersion(builder.build());
    }
    
    public N endPreferredVersion() {
      return and();
    }
    
  
  }
  public class ServerAddressByClientCIDRsNested<N> extends ServerAddressByClientCIDRFluent<ServerAddressByClientCIDRsNested<N>> implements Nested<N>{
    ServerAddressByClientCIDRsNested(int index,ServerAddressByClientCIDR item) {
      this.index = index;
      this.builder = new ServerAddressByClientCIDRBuilder(this, item);
    }
    ServerAddressByClientCIDRBuilder builder;
    int index;
    
    public N and() {
      return (N) APIGroupFluent.this.setToServerAddressByClientCIDRs(index,builder.build());
    }
    
    public N endServerAddressByClientCIDR() {
      return and();
    }
    
  
  }
  public class VersionsNested<N> extends GroupVersionForDiscoveryFluent<VersionsNested<N>> implements Nested<N>{
    VersionsNested(int index,GroupVersionForDiscovery item) {
      this.index = index;
      this.builder = new GroupVersionForDiscoveryBuilder(this, item);
    }
    GroupVersionForDiscoveryBuilder builder;
    int index;
    
    public N and() {
      return (N) APIGroupFluent.this.setToVersions(index,builder.build());
    }
    
    public N endVersion() {
      return and();
    }
    
  
  }

}