package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LifecycleBuilder extends LifecycleFluent<LifecycleBuilder> implements VisitableBuilder<Lifecycle,LifecycleBuilder>{
  public LifecycleBuilder() {
    this(new Lifecycle());
  }
  
  public LifecycleBuilder(LifecycleFluent<?> fluent) {
    this(fluent, new Lifecycle());
  }
  
  public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LifecycleBuilder(Lifecycle instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LifecycleFluent<?> fluent;
  
  public Lifecycle build() {
    Lifecycle buildable = new Lifecycle(fluent.buildPostStart(),fluent.buildPreStop(),fluent.getStopSignal());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}