/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.NamespaceSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NamespaceSpecFluent<A extends NamespaceSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> finalizers = new ArrayList<String>();

    public NamespaceSpecFluent() {
    }

    public NamespaceSpecFluent(NamespaceSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToFinalizers(String ... items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)((Object)this);
    }

    public A addToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(NamespaceSpec instance) {
        NamespaceSpec namespaceSpec = instance = instance != null ? instance : new NamespaceSpec();
        if (instance != null) {
            this.withFinalizers(instance.getFinalizers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceSpecFluent that = (NamespaceSpecFluent)((Object)o);
        if (!Objects.equals(this.finalizers, that.finalizers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    public List<String> getFinalizers() {
        return this.finalizers;
    }

    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    public boolean hasMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.finalizers, this.additionalProperties);
    }

    public A removeAllFromFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromFinalizers(String ... items) {
        if (this.finalizers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.finalizers != null && !this.finalizers.isEmpty()) {
            sb.append("finalizers:");
            sb.append(this.finalizers);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFinalizers(List<String> finalizers) {
        if (finalizers != null) {
            this.finalizers = new ArrayList<String>();
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        } else {
            this.finalizers = null;
        }
        return (A)((Object)this);
    }

    public A withFinalizers(String ... finalizers) {
        if (this.finalizers != null) {
            this.finalizers.clear();
            this._visitables.remove((Object)"finalizers");
        }
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)((Object)this);
    }
}

