package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointConditionsBuilder extends io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder> {

    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EndpointConditionsBuilder() {
        this(true);
    }

    public EndpointConditionsBuilder(java.lang.Boolean validationEnabled) {
        this(new EndpointConditions(), validationEnabled);
    }

    public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EndpointConditions(), validationEnabled);
    }

    public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions instance) {
        this(fluent, instance, true);
    }

    public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReady(instance.getReady()); 
        fluent.withServing(instance.getServing()); 
        fluent.withTerminating(instance.getTerminating()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions instance) {
        this(instance,true);
    }

    public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withReady(instance.getReady()); 
        this.withServing(instance.getServing()); 
        this.withTerminating(instance.getTerminating()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions build() {
        EndpointConditions buildable = new EndpointConditions(fluent.getReady(),fluent.getServing(),fluent.getTerminating());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointConditionsBuilder that = (EndpointConditionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
