package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ForZoneBuilder extends ForZoneFluentImpl<ForZoneBuilder> implements VisitableBuilder<ForZone,ForZoneBuilder>{
  public ForZoneBuilder() {
    this(false);
  }
  public ForZoneBuilder(Boolean validationEnabled) {
    this(new ForZone(), validationEnabled);
  }
  public ForZoneBuilder(ForZoneFluent<?> fluent) {
    this(fluent, false);
  }
  public ForZoneBuilder(ForZoneFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ForZone(), validationEnabled);
  }
  public ForZoneBuilder(ForZoneFluent<?> fluent,ForZone instance) {
    this(fluent, instance, false);
  }
  public ForZoneBuilder(ForZoneFluent<?> fluent,ForZone instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ForZoneBuilder(ForZone instance) {
    this(instance,false);
  }
  public ForZoneBuilder(ForZone instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ForZoneFluent<?> fluent;
  Boolean validationEnabled;
  public ForZone build() {
    ForZone buildable = new ForZone(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}