package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointFluentImpl<A extends EndpointFluent<A>> extends BaseFluent<A> implements EndpointFluent<A>{
  public EndpointFluentImpl() {
  }
  public EndpointFluentImpl(Endpoint instance) {
    if (instance != null) {
      this.withAddresses(instance.getAddresses());
      this.withConditions(instance.getConditions());
      this.withHints(instance.getHints());
      this.withHostname(instance.getHostname());
      this.withNodeName(instance.getNodeName());
      this.withTargetRef(instance.getTargetRef());
      this.withTopology(instance.getTopology());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> addresses = new ArrayList<String>();
  private EndpointConditionsBuilder conditions;
  private EndpointHintsBuilder hints;
  private String hostname;
  private String nodeName;
  private ObjectReferenceBuilder targetRef;
  private Map<String,String> topology;
  private Map<String,Object> additionalProperties;
  public A addToAddresses(int index,String item) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    this.addresses.add(index, item);
    return (A)this;
  }
  public A setToAddresses(int index,String item) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    this.addresses.set(index, item); return (A)this;
  }
  public A addToAddresses(java.lang.String... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    for (String item : items) {this.addresses.add(item);} return (A)this;
  }
  public A addAllToAddresses(Collection<String> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    for (String item : items) {this.addresses.add(item);} return (A)this;
  }
  public A removeFromAddresses(java.lang.String... items) {
    for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public A removeAllFromAddresses(Collection<String> items) {
    for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public List<String> getAddresses() {
    return this.addresses;
  }
  public String getAddress(int index) {
    return this.addresses.get(index);
  }
  public String getFirstAddress() {
    return this.addresses.get(0);
  }
  public String getLastAddress() {
    return this.addresses.get(addresses.size() - 1);
  }
  public String getMatchingAddress(Predicate<String> predicate) {
    for (String item: addresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAddress(Predicate<String> predicate) {
    for (String item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(List<String> addresses) {
    if (addresses != null) {this.addresses = new ArrayList(); for (String item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(java.lang.String... addresses) {
    if (this.addresses != null) {this.addresses.clear(); _visitables.remove("addresses"); }
    if (addresses != null) {for (String item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointConditions getConditions() {
    return this.conditions!=null ?this.conditions.build():null;
  }
  public EndpointConditions buildConditions() {
    return this.conditions!=null ?this.conditions.build():null;
  }
  public A withConditions(EndpointConditions conditions) {
    _visitables.get("conditions").remove(this.conditions);
    if (conditions!=null){ this.conditions= new EndpointConditionsBuilder(conditions); _visitables.get("conditions").add(this.conditions);} else { this.conditions = null; _visitables.get("conditions").remove(this.conditions); } return (A) this;
  }
  public Boolean hasConditions() {
    return this.conditions != null;
  }
  public A withNewConditions(Boolean ready,Boolean serving,Boolean terminating) {
    return (A)withConditions(new EndpointConditions(ready, serving, terminating));
  }
  public EndpointFluentImpl.ConditionsNested<A> withNewConditions() {
    return new EndpointFluentImpl.ConditionsNestedImpl();
  }
  public EndpointFluentImpl.ConditionsNested<A> withNewConditionsLike(EndpointConditions item) {
    return new EndpointFluentImpl.ConditionsNestedImpl(item);
  }
  public EndpointFluentImpl.ConditionsNested<A> editConditions() {
    return withNewConditionsLike(getConditions());
  }
  public EndpointFluentImpl.ConditionsNested<A> editOrNewConditions() {
    return withNewConditionsLike(getConditions() != null ? getConditions(): new EndpointConditionsBuilder().build());
  }
  public EndpointFluentImpl.ConditionsNested<A> editOrNewConditionsLike(EndpointConditions item) {
    return withNewConditionsLike(getConditions() != null ? getConditions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHints instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointHints getHints() {
    return this.hints!=null ?this.hints.build():null;
  }
  public EndpointHints buildHints() {
    return this.hints!=null ?this.hints.build():null;
  }
  public A withHints(EndpointHints hints) {
    _visitables.get("hints").remove(this.hints);
    if (hints!=null){ this.hints= new EndpointHintsBuilder(hints); _visitables.get("hints").add(this.hints);} else { this.hints = null; _visitables.get("hints").remove(this.hints); } return (A) this;
  }
  public Boolean hasHints() {
    return this.hints != null;
  }
  public EndpointFluentImpl.HintsNested<A> withNewHints() {
    return new EndpointFluentImpl.HintsNestedImpl();
  }
  public EndpointFluentImpl.HintsNested<A> withNewHintsLike(EndpointHints item) {
    return new EndpointFluentImpl.HintsNestedImpl(item);
  }
  public EndpointFluentImpl.HintsNested<A> editHints() {
    return withNewHintsLike(getHints());
  }
  public EndpointFluentImpl.HintsNested<A> editOrNewHints() {
    return withNewHintsLike(getHints() != null ? getHints(): new EndpointHintsBuilder().build());
  }
  public EndpointFluentImpl.HintsNested<A> editOrNewHintsLike(EndpointHints item) {
    return withNewHintsLike(getHints() != null ? getHints(): item);
  }
  public String getHostname() {
    return this.hostname;
  }
  public A withHostname(String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public Boolean hasHostname() {
    return this.hostname != null;
  }
  public String getNodeName() {
    return this.nodeName;
  }
  public A withNodeName(String nodeName) {
    this.nodeName=nodeName; return (A) this;
  }
  public Boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTargetRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getTargetRef() {
    return this.targetRef!=null ?this.targetRef.build():null;
  }
  public ObjectReference buildTargetRef() {
    return this.targetRef!=null ?this.targetRef.build():null;
  }
  public A withTargetRef(ObjectReference targetRef) {
    _visitables.get("targetRef").remove(this.targetRef);
    if (targetRef!=null){ this.targetRef= new ObjectReferenceBuilder(targetRef); _visitables.get("targetRef").add(this.targetRef);} else { this.targetRef = null; _visitables.get("targetRef").remove(this.targetRef); } return (A) this;
  }
  public Boolean hasTargetRef() {
    return this.targetRef != null;
  }
  public EndpointFluentImpl.TargetRefNested<A> withNewTargetRef() {
    return new EndpointFluentImpl.TargetRefNestedImpl();
  }
  public EndpointFluentImpl.TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
    return new EndpointFluentImpl.TargetRefNestedImpl(item);
  }
  public EndpointFluentImpl.TargetRefNested<A> editTargetRef() {
    return withNewTargetRefLike(getTargetRef());
  }
  public EndpointFluentImpl.TargetRefNested<A> editOrNewTargetRef() {
    return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): new ObjectReferenceBuilder().build());
  }
  public EndpointFluentImpl.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item) {
    return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): item);
  }
  public A addToTopology(String key,String value) {
    if(this.topology == null && key != null && value != null) { this.topology = new LinkedHashMap(); }
    if(key != null && value != null) {this.topology.put(key, value);} return (A)this;
  }
  public A addToTopology(Map<String,String> map) {
    if(this.topology == null && map != null) { this.topology = new LinkedHashMap(); }
    if(map != null) { this.topology.putAll(map);} return (A)this;
  }
  public A removeFromTopology(String key) {
    if(this.topology == null) { return (A) this; }
    if(key != null && this.topology != null) {this.topology.remove(key);} return (A)this;
  }
  public A removeFromTopology(Map<String,String> map) {
    if(this.topology == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.topology != null){this.topology.remove(key);}}} return (A)this;
  }
  public Map<String,String> getTopology() {
    return this.topology;
  }
  public <K,V>A withTopology(Map<String,String> topology) {
    if (topology == null) { this.topology =  null;} else {this.topology = new LinkedHashMap(topology);} return (A) this;
  }
  public Boolean hasTopology() {
    return this.topology != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointFluentImpl that = (EndpointFluentImpl) o;
    if (!java.util.Objects.equals(addresses, that.addresses)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(hints, that.hints)) return false;

    if (!java.util.Objects.equals(hostname, that.hostname)) return false;

    if (!java.util.Objects.equals(nodeName, that.nodeName)) return false;

    if (!java.util.Objects.equals(targetRef, that.targetRef)) return false;

    if (!java.util.Objects.equals(topology, that.topology)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  conditions,  hints,  hostname,  nodeName,  targetRef,  topology,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (hints != null) { sb.append("hints:"); sb.append(hints + ","); }
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (targetRef != null) { sb.append("targetRef:"); sb.append(targetRef + ","); }
    if (topology != null && !topology.isEmpty()) { sb.append("topology:"); sb.append(topology + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends EndpointConditionsFluentImpl<EndpointFluentImpl.ConditionsNested<N>> implements EndpointFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(EndpointConditions item) {
      this.builder = new EndpointConditionsBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.builder = new EndpointConditionsBuilder(this);
    }
    EndpointConditionsBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withConditions(builder.build());
    }
    public N endConditions() {
      return and();
    }
    
  }
  class HintsNestedImpl<N> extends EndpointHintsFluentImpl<EndpointFluentImpl.HintsNested<N>> implements EndpointFluentImpl.HintsNested<N>,Nested<N>{
    HintsNestedImpl(EndpointHints item) {
      this.builder = new EndpointHintsBuilder(this, item);
    }
    HintsNestedImpl() {
      this.builder = new EndpointHintsBuilder(this);
    }
    EndpointHintsBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withHints(builder.build());
    }
    public N endHints() {
      return and();
    }
    
  }
  class TargetRefNestedImpl<N> extends ObjectReferenceFluentImpl<EndpointFluentImpl.TargetRefNested<N>> implements EndpointFluentImpl.TargetRefNested<N>,Nested<N>{
    TargetRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    TargetRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withTargetRef(builder.build());
    }
    public N endTargetRef() {
      return and();
    }
    
  }
  
}