package io.fabric8.kubernetes.api.model.discovery.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface EndpointFluent<A extends EndpointFluent<A>> extends Fluent<A>{
  public A addToAddresses(int index,String item);
  public A setToAddresses(int index,String item);
  public A addToAddresses(java.lang.String... items);
  public A addAllToAddresses(Collection<String> items);
  public A removeFromAddresses(java.lang.String... items);
  public A removeAllFromAddresses(Collection<String> items);
  public List<String> getAddresses();
  public String getAddress(int index);
  public String getFirstAddress();
  public String getLastAddress();
  public String getMatchingAddress(Predicate<String> predicate);
  public Boolean hasMatchingAddress(Predicate<String> predicate);
  public A withAddresses(List<String> addresses);
  public A withAddresses(java.lang.String... addresses);
  public Boolean hasAddresses();
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointConditions getConditions();
  public EndpointConditions buildConditions();
  public A withConditions(EndpointConditions conditions);
  public Boolean hasConditions();
  public A withNewConditions(Boolean ready,Boolean serving,Boolean terminating);
  public EndpointFluent.ConditionsNested<A> withNewConditions();
  public EndpointFluent.ConditionsNested<A> withNewConditionsLike(EndpointConditions item);
  public EndpointFluent.ConditionsNested<A> editConditions();
  public EndpointFluent.ConditionsNested<A> editOrNewConditions();
  public EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(EndpointConditions item);
  public A addToDeprecatedTopology(String key,String value);
  public A addToDeprecatedTopology(Map<String,String> map);
  public A removeFromDeprecatedTopology(String key);
  public A removeFromDeprecatedTopology(Map<String,String> map);
  public Map<String,String> getDeprecatedTopology();
  public <K,V>A withDeprecatedTopology(Map<String,String> deprecatedTopology);
  public Boolean hasDeprecatedTopology();
  
  /**
   * This method has been deprecated, please use method buildHints instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointHints getHints();
  public EndpointHints buildHints();
  public A withHints(EndpointHints hints);
  public Boolean hasHints();
  public EndpointFluent.HintsNested<A> withNewHints();
  public EndpointFluent.HintsNested<A> withNewHintsLike(EndpointHints item);
  public EndpointFluent.HintsNested<A> editHints();
  public EndpointFluent.HintsNested<A> editOrNewHints();
  public EndpointFluent.HintsNested<A> editOrNewHintsLike(EndpointHints item);
  public String getHostname();
  public A withHostname(String hostname);
  public Boolean hasHostname();
  public String getNodeName();
  public A withNodeName(String nodeName);
  public Boolean hasNodeName();
  
  /**
   * This method has been deprecated, please use method buildTargetRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getTargetRef();
  public ObjectReference buildTargetRef();
  public A withTargetRef(ObjectReference targetRef);
  public Boolean hasTargetRef();
  public EndpointFluent.TargetRefNested<A> withNewTargetRef();
  public EndpointFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item);
  public EndpointFluent.TargetRefNested<A> editTargetRef();
  public EndpointFluent.TargetRefNested<A> editOrNewTargetRef();
  public EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item);
  public String getZone();
  public A withZone(String zone);
  public Boolean hasZone();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,EndpointConditionsFluent<EndpointFluent.ConditionsNested<N>>{
    public N and();
    public N endConditions();
    
  }
  public interface HintsNested<N> extends Nested<N>,EndpointHintsFluent<EndpointFluent.HintsNested<N>>{
    public N and();
    public N endHints();
    
  }
  public interface TargetRefNested<N> extends Nested<N>,ObjectReferenceFluent<EndpointFluent.TargetRefNested<N>>{
    public N and();
    public N endTargetRef();
    
  }
  
}