package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointSliceBuilder extends EndpointSliceFluentImpl<EndpointSliceBuilder> implements VisitableBuilder<EndpointSlice,EndpointSliceBuilder>{
  public EndpointSliceBuilder() {
    this(false);
  }
  public EndpointSliceBuilder(Boolean validationEnabled) {
    this(new EndpointSlice(), validationEnabled);
  }
  public EndpointSliceBuilder(EndpointSliceFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointSliceBuilder(EndpointSliceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointSlice(), validationEnabled);
  }
  public EndpointSliceBuilder(EndpointSliceFluent<?> fluent,EndpointSlice instance) {
    this(fluent, instance, false);
  }
  public EndpointSliceBuilder(EndpointSliceFluent<?> fluent,EndpointSlice instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddressType(instance.getAddressType());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withEndpoints(instance.getEndpoints());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withPorts(instance.getPorts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointSliceBuilder(EndpointSlice instance) {
    this(instance,false);
  }
  public EndpointSliceBuilder(EndpointSlice instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddressType(instance.getAddressType());
      this.withApiVersion(instance.getApiVersion());
      this.withEndpoints(instance.getEndpoints());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withPorts(instance.getPorts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointSliceFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointSlice build() {
    EndpointSlice buildable = new EndpointSlice(fluent.getAddressType(),fluent.getApiVersion(),fluent.getEndpoints(),fluent.getKind(),fluent.getMetadata(),fluent.getPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}