package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface EndpointSliceFluent<A extends EndpointSliceFluent<A>> extends Fluent<A>{
  public String getAddressType();
  public A withAddressType(String addressType);
  public Boolean hasAddressType();
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToEndpoints(int index,Endpoint item);
  public A setToEndpoints(int index,Endpoint item);
  public A addToEndpoints(io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint... items);
  public A addAllToEndpoints(Collection<Endpoint> items);
  public A removeFromEndpoints(io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint... items);
  public A removeAllFromEndpoints(Collection<Endpoint> items);
  public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Endpoint> getEndpoints();
  public List<Endpoint> buildEndpoints();
  public Endpoint buildEndpoint(int index);
  public Endpoint buildFirstEndpoint();
  public Endpoint buildLastEndpoint();
  public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate);
  public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate);
  public A withEndpoints(List<Endpoint> endpoints);
  public A withEndpoints(io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint... endpoints);
  public Boolean hasEndpoints();
  public EndpointSliceFluent.EndpointsNested<A> addNewEndpoint();
  public EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item);
  public EndpointSliceFluent.EndpointsNested<A> setNewEndpointLike(int index,Endpoint item);
  public EndpointSliceFluent.EndpointsNested<A> editEndpoint(int index);
  public EndpointSliceFluent.EndpointsNested<A> editFirstEndpoint();
  public EndpointSliceFluent.EndpointsNested<A> editLastEndpoint();
  public EndpointSliceFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public EndpointSliceFluent.MetadataNested<A> withNewMetadata();
  public EndpointSliceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public EndpointSliceFluent.MetadataNested<A> editMetadata();
  public EndpointSliceFluent.MetadataNested<A> editOrNewMetadata();
  public EndpointSliceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToPorts(int index,EndpointPort item);
  public A setToPorts(int index,EndpointPort item);
  public A addToPorts(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort... items);
  public A addAllToPorts(Collection<EndpointPort> items);
  public A removeFromPorts(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort... items);
  public A removeAllFromPorts(Collection<EndpointPort> items);
  public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EndpointPort> getPorts();
  public List<EndpointPort> buildPorts();
  public EndpointPort buildPort(int index);
  public EndpointPort buildFirstPort();
  public EndpointPort buildLastPort();
  public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate);
  public Boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate);
  public A withPorts(List<EndpointPort> ports);
  public A withPorts(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort... ports);
  public Boolean hasPorts();
  public A addNewPort(String appProtocol,String name,Integer port,String protocol);
  public EndpointSliceFluent.PortsNested<A> addNewPort();
  public EndpointSliceFluent.PortsNested<A> addNewPortLike(EndpointPort item);
  public EndpointSliceFluent.PortsNested<A> setNewPortLike(int index,EndpointPort item);
  public EndpointSliceFluent.PortsNested<A> editPort(int index);
  public EndpointSliceFluent.PortsNested<A> editFirstPort();
  public EndpointSliceFluent.PortsNested<A> editLastPort();
  public EndpointSliceFluent.PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface EndpointsNested<N> extends Nested<N>,EndpointFluent<EndpointSliceFluent.EndpointsNested<N>>{
    public N and();
    public N endEndpoint();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<EndpointSliceFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface PortsNested<N> extends Nested<N>,EndpointPortFluent<EndpointSliceFluent.PortsNested<N>>{
    public N and();
    public N endPort();
    
  }
  
}