
package io.fabric8.kubernetes.api.model.events.v1beta1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.TemplateTransformation;
import io.sundr.transform.annotations.TemplateTransformations;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "action",
    "deprecatedCount",
    "deprecatedFirstTimestamp",
    "deprecatedLastTimestamp",
    "deprecatedSource",
    "eventTime",
    "note",
    "reason",
    "regarding",
    "related",
    "reportingController",
    "reportingInstance",
    "series",
    "type"
})
@ToString
@EqualsAndHashCode
@Setter
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
@TemplateTransformations({
    @TemplateTransformation(value = "/manifest.vm", outputPath = "META-INF/services/io.fabric8.kubernetes.api.model.KubernetesResource", gather = true)
})
@Version("v1beta1")
@Group("events.k8s.io")
public class Event implements HasMetadata, Namespaced
{

    @JsonProperty("action")
    private java.lang.String action;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apiVersion")
    private java.lang.String apiVersion = "events.k8s.io/v1beta1";
    @JsonProperty("deprecatedCount")
    private Integer deprecatedCount;
    @JsonProperty("deprecatedFirstTimestamp")
    private String deprecatedFirstTimestamp;
    @JsonProperty("deprecatedLastTimestamp")
    private String deprecatedLastTimestamp;
    @JsonProperty("deprecatedSource")
    private EventSource deprecatedSource;
    @JsonProperty("eventTime")
    private MicroTime eventTime;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("kind")
    private java.lang.String kind = "Event";
    @JsonProperty("metadata")
    private io.fabric8.kubernetes.api.model.ObjectMeta metadata;
    @JsonProperty("note")
    private java.lang.String note;
    @JsonProperty("reason")
    private java.lang.String reason;
    @JsonProperty("regarding")
    private io.fabric8.kubernetes.api.model.ObjectReference regarding;
    @JsonProperty("related")
    private io.fabric8.kubernetes.api.model.ObjectReference related;
    @JsonProperty("reportingController")
    private java.lang.String reportingController;
    @JsonProperty("reportingInstance")
    private java.lang.String reportingInstance;
    @JsonProperty("series")
    private EventSeries series;
    @JsonProperty("type")
    private java.lang.String type;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Event() {
    }

    /**
     * 
     * @param note
     * @param reason
     * @param metadata
     * @param reportingInstance
     * @param deprecatedCount
     * @param kind
     * @param deprecatedSource
     * @param type
     * @param deprecatedLastTimestamp
     * @param regarding
     * @param deprecatedFirstTimestamp
     * @param apiVersion
     * @param reportingController
     * @param related
     * @param series
     * @param eventTime
     * @param action
     */
    public Event(java.lang.String action, java.lang.String apiVersion, Integer deprecatedCount, String deprecatedFirstTimestamp, String deprecatedLastTimestamp, EventSource deprecatedSource, MicroTime eventTime, java.lang.String kind, io.fabric8.kubernetes.api.model.ObjectMeta metadata, java.lang.String note, java.lang.String reason, io.fabric8.kubernetes.api.model.ObjectReference regarding, io.fabric8.kubernetes.api.model.ObjectReference related, java.lang.String reportingController, java.lang.String reportingInstance, EventSeries series, java.lang.String type) {
        super();
        this.action = action;
        this.apiVersion = apiVersion;
        this.deprecatedCount = deprecatedCount;
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
        this.deprecatedSource = deprecatedSource;
        this.eventTime = eventTime;
        this.kind = kind;
        this.metadata = metadata;
        this.note = note;
        this.reason = reason;
        this.regarding = regarding;
        this.related = related;
        this.reportingController = reportingController;
        this.reportingInstance = reportingInstance;
        this.series = series;
        this.type = type;
    }

    @JsonProperty("action")
    public java.lang.String getAction() {
        return action;
    }

    @JsonProperty("action")
    public void setAction(java.lang.String action) {
        this.action = action;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apiVersion")
    public java.lang.String getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(java.lang.String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty("deprecatedCount")
    public Integer getDeprecatedCount() {
        return deprecatedCount;
    }

    @JsonProperty("deprecatedCount")
    public void setDeprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
    }

    @JsonProperty("deprecatedFirstTimestamp")
    public String getDeprecatedFirstTimestamp() {
        return deprecatedFirstTimestamp;
    }

    @JsonProperty("deprecatedFirstTimestamp")
    public void setDeprecatedFirstTimestamp(String deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
    }

    @JsonProperty("deprecatedLastTimestamp")
    public String getDeprecatedLastTimestamp() {
        return deprecatedLastTimestamp;
    }

    @JsonProperty("deprecatedLastTimestamp")
    public void setDeprecatedLastTimestamp(String deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
    }

    @JsonProperty("deprecatedSource")
    public EventSource getDeprecatedSource() {
        return deprecatedSource;
    }

    @JsonProperty("deprecatedSource")
    public void setDeprecatedSource(EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
    }

    @JsonProperty("eventTime")
    public MicroTime getEventTime() {
        return eventTime;
    }

    @JsonProperty("eventTime")
    public void setEventTime(MicroTime eventTime) {
        this.eventTime = eventTime;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("kind")
    public java.lang.String getKind() {
        return kind;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("kind")
    public void setKind(java.lang.String kind) {
        this.kind = kind;
    }

    @JsonProperty("metadata")
    public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return metadata;
    }

    @JsonProperty("metadata")
    public void setMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty("note")
    public java.lang.String getNote() {
        return note;
    }

    @JsonProperty("note")
    public void setNote(java.lang.String note) {
        this.note = note;
    }

    @JsonProperty("reason")
    public java.lang.String getReason() {
        return reason;
    }

    @JsonProperty("reason")
    public void setReason(java.lang.String reason) {
        this.reason = reason;
    }

    @JsonProperty("regarding")
    public io.fabric8.kubernetes.api.model.ObjectReference getRegarding() {
        return regarding;
    }

    @JsonProperty("regarding")
    public void setRegarding(io.fabric8.kubernetes.api.model.ObjectReference regarding) {
        this.regarding = regarding;
    }

    @JsonProperty("related")
    public io.fabric8.kubernetes.api.model.ObjectReference getRelated() {
        return related;
    }

    @JsonProperty("related")
    public void setRelated(io.fabric8.kubernetes.api.model.ObjectReference related) {
        this.related = related;
    }

    @JsonProperty("reportingController")
    public java.lang.String getReportingController() {
        return reportingController;
    }

    @JsonProperty("reportingController")
    public void setReportingController(java.lang.String reportingController) {
        this.reportingController = reportingController;
    }

    @JsonProperty("reportingInstance")
    public java.lang.String getReportingInstance() {
        return reportingInstance;
    }

    @JsonProperty("reportingInstance")
    public void setReportingInstance(java.lang.String reportingInstance) {
        this.reportingInstance = reportingInstance;
    }

    @JsonProperty("series")
    public EventSeries getSeries() {
        return series;
    }

    @JsonProperty("series")
    public void setSeries(EventSeries series) {
        this.series = series;
    }

    @JsonProperty("type")
    public java.lang.String getType() {
        return type;
    }

    @JsonProperty("type")
    public void setType(java.lang.String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
