package io.fabric8.kubernetes.api.model.events.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EventSeriesFluent<A extends EventSeriesFluent<A>> extends BaseFluent<A>{
  public EventSeriesFluent() {
  }
  public EventSeriesFluent(EventSeries instance) {
    instance = (instance != null ? instance : new EventSeries());

    if (instance != null) {
      this.withCount(instance.getCount());
      this.withLastObservedTime(instance.getLastObservedTime());
      this.withCount(instance.getCount());
      this.withLastObservedTime(instance.getLastObservedTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Integer count;
  private MicroTime lastObservedTime;
  private Map<String,Object> additionalProperties;
  public Integer getCount() {
    return this.count;
  }
  public A withCount(Integer count) {
    this.count=count; return (A) this;
  }
  public boolean hasCount() {
    return this.count != null;
  }
  public MicroTime getLastObservedTime() {
    return this.lastObservedTime;
  }
  public A withLastObservedTime(MicroTime lastObservedTime) {
    this.lastObservedTime=lastObservedTime; return (A) this;
  }
  public boolean hasLastObservedTime() {
    return this.lastObservedTime != null;
  }
  public A withNewLastObservedTime(String time) {
    return (A)withLastObservedTime(new MicroTime(time));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EventSeriesFluent that = (EventSeriesFluent) o;
    if (!java.util.Objects.equals(count, that.count)) return false;

    if (!java.util.Objects.equals(lastObservedTime, that.lastObservedTime)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(count,  lastObservedTime,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (count != null) { sb.append("count:"); sb.append(count + ","); }
    if (lastObservedTime != null) { sb.append("lastObservedTime:"); sb.append(lastObservedTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}