package io.fabric8.kubernetes.api.model.events.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EventSeriesBuilder extends EventSeriesFluent<EventSeriesBuilder> implements VisitableBuilder<EventSeries,EventSeriesBuilder>{
  public EventSeriesBuilder() {
    this(new EventSeries());
  }
  
  public EventSeriesBuilder(EventSeriesFluent<?> fluent) {
    this(fluent, new EventSeries());
  }
  
  public EventSeriesBuilder(EventSeriesFluent<?> fluent,EventSeries instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EventSeriesBuilder(EventSeries instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EventSeriesFluent<?> fluent;
  
  public EventSeries build() {
    EventSeries buildable = new EventSeries(fluent.getCount(),fluent.getLastObservedTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}