package io.fabric8.kubernetes.api.model.events.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EventFluent<A extends EventFluent<A>> extends BaseFluent<A>{
  public EventFluent() {
  }
  
  public EventFluent(Event instance) {
    this.copyInstance(instance);
  }
  private String action;
  private String apiVersion;
  private Integer deprecatedCount;
  private String deprecatedFirstTimestamp;
  private String deprecatedLastTimestamp;
  private EventSource deprecatedSource;
  private MicroTime eventTime;
  private String kind;
  private ObjectMetaBuilder metadata;
  private String note;
  private String reason;
  private ObjectReferenceBuilder regarding;
  private ObjectReferenceBuilder related;
  private String reportingController;
  private String reportingInstance;
  private EventSeriesBuilder series;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Event instance) {
    instance = (instance != null ? instance : new Event());
  
    if (instance != null) {
        this.withAction(instance.getAction());
        this.withApiVersion(instance.getApiVersion());
        this.withDeprecatedCount(instance.getDeprecatedCount());
        this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());
        this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());
        this.withDeprecatedSource(instance.getDeprecatedSource());
        this.withEventTime(instance.getEventTime());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withNote(instance.getNote());
        this.withReason(instance.getReason());
        this.withRegarding(instance.getRegarding());
        this.withRelated(instance.getRelated());
        this.withReportingController(instance.getReportingController());
        this.withReportingInstance(instance.getReportingInstance());
        this.withSeries(instance.getSeries());
        this.withType(instance.getType());
        this.withAction(instance.getAction());
        this.withApiVersion(instance.getApiVersion());
        this.withDeprecatedCount(instance.getDeprecatedCount());
        this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());
        this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());
        this.withDeprecatedSource(instance.getDeprecatedSource());
        this.withEventTime(instance.getEventTime());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withNote(instance.getNote());
        this.withReason(instance.getReason());
        this.withRegarding(instance.getRegarding());
        this.withRelated(instance.getRelated());
        this.withReportingController(instance.getReportingController());
        this.withReportingInstance(instance.getReportingInstance());
        this.withSeries(instance.getSeries());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getAction() {
    return this.action;
  }
  
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  
  public boolean hasAction() {
    return this.action != null;
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public Integer getDeprecatedCount() {
    return this.deprecatedCount;
  }
  
  public A withDeprecatedCount(Integer deprecatedCount) {
    this.deprecatedCount=deprecatedCount; return (A) this;
  }
  
  public boolean hasDeprecatedCount() {
    return this.deprecatedCount != null;
  }
  
  public String getDeprecatedFirstTimestamp() {
    return this.deprecatedFirstTimestamp;
  }
  
  public A withDeprecatedFirstTimestamp(String deprecatedFirstTimestamp) {
    this.deprecatedFirstTimestamp=deprecatedFirstTimestamp; return (A) this;
  }
  
  public boolean hasDeprecatedFirstTimestamp() {
    return this.deprecatedFirstTimestamp != null;
  }
  
  public String getDeprecatedLastTimestamp() {
    return this.deprecatedLastTimestamp;
  }
  
  public A withDeprecatedLastTimestamp(String deprecatedLastTimestamp) {
    this.deprecatedLastTimestamp=deprecatedLastTimestamp; return (A) this;
  }
  
  public boolean hasDeprecatedLastTimestamp() {
    return this.deprecatedLastTimestamp != null;
  }
  
  public EventSource getDeprecatedSource() {
    return this.deprecatedSource;
  }
  
  public A withDeprecatedSource(EventSource deprecatedSource) {
    this.deprecatedSource=deprecatedSource; return (A) this;
  }
  
  public boolean hasDeprecatedSource() {
    return this.deprecatedSource != null;
  }
  
  public A withNewDeprecatedSource(String component,String host) {
    return (A)withDeprecatedSource(new EventSource(component, host));
  }
  
  public MicroTime getEventTime() {
    return this.eventTime;
  }
  
  public A withEventTime(MicroTime eventTime) {
    this.eventTime=eventTime; return (A) this;
  }
  
  public boolean hasEventTime() {
    return this.eventTime != null;
  }
  
  public A withNewEventTime(String time) {
    return (A)withEventTime(new MicroTime(time));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public String getNote() {
    return this.note;
  }
  
  public A withNote(String note) {
    this.note=note; return (A) this;
  }
  
  public boolean hasNote() {
    return this.note != null;
  }
  
  public String getReason() {
    return this.reason;
  }
  
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  
  public boolean hasReason() {
    return this.reason != null;
  }
  
  public ObjectReference buildRegarding() {
    return this.regarding!=null ?this.regarding.build():null;
  }
  
  public A withRegarding(ObjectReference regarding) {
    _visitables.get("regarding").remove(this.regarding);
    if (regarding!=null){ this.regarding= new ObjectReferenceBuilder(regarding); _visitables.get("regarding").add(this.regarding);} else { this.regarding = null; _visitables.get("regarding").remove(this.regarding); } return (A) this;
  }
  
  public boolean hasRegarding() {
    return this.regarding != null;
  }
  
  public RegardingNested<A> withNewRegarding() {
    return new RegardingNested(null);
  }
  
  public RegardingNested<A> withNewRegardingLike(ObjectReference item) {
    return new RegardingNested(item);
  }
  
  public RegardingNested<A> editRegarding() {
    return withNewRegardingLike(java.util.Optional.ofNullable(buildRegarding()).orElse(null));
  }
  
  public RegardingNested<A> editOrNewRegarding() {
    return withNewRegardingLike(java.util.Optional.ofNullable(buildRegarding()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public RegardingNested<A> editOrNewRegardingLike(ObjectReference item) {
    return withNewRegardingLike(java.util.Optional.ofNullable(buildRegarding()).orElse(item));
  }
  
  public ObjectReference buildRelated() {
    return this.related!=null ?this.related.build():null;
  }
  
  public A withRelated(ObjectReference related) {
    _visitables.get("related").remove(this.related);
    if (related!=null){ this.related= new ObjectReferenceBuilder(related); _visitables.get("related").add(this.related);} else { this.related = null; _visitables.get("related").remove(this.related); } return (A) this;
  }
  
  public boolean hasRelated() {
    return this.related != null;
  }
  
  public RelatedNested<A> withNewRelated() {
    return new RelatedNested(null);
  }
  
  public RelatedNested<A> withNewRelatedLike(ObjectReference item) {
    return new RelatedNested(item);
  }
  
  public RelatedNested<A> editRelated() {
    return withNewRelatedLike(java.util.Optional.ofNullable(buildRelated()).orElse(null));
  }
  
  public RelatedNested<A> editOrNewRelated() {
    return withNewRelatedLike(java.util.Optional.ofNullable(buildRelated()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public RelatedNested<A> editOrNewRelatedLike(ObjectReference item) {
    return withNewRelatedLike(java.util.Optional.ofNullable(buildRelated()).orElse(item));
  }
  
  public String getReportingController() {
    return this.reportingController;
  }
  
  public A withReportingController(String reportingController) {
    this.reportingController=reportingController; return (A) this;
  }
  
  public boolean hasReportingController() {
    return this.reportingController != null;
  }
  
  public String getReportingInstance() {
    return this.reportingInstance;
  }
  
  public A withReportingInstance(String reportingInstance) {
    this.reportingInstance=reportingInstance; return (A) this;
  }
  
  public boolean hasReportingInstance() {
    return this.reportingInstance != null;
  }
  
  public EventSeries buildSeries() {
    return this.series!=null ?this.series.build():null;
  }
  
  public A withSeries(EventSeries series) {
    _visitables.get("series").remove(this.series);
    if (series!=null){ this.series= new EventSeriesBuilder(series); _visitables.get("series").add(this.series);} else { this.series = null; _visitables.get("series").remove(this.series); } return (A) this;
  }
  
  public boolean hasSeries() {
    return this.series != null;
  }
  
  public SeriesNested<A> withNewSeries() {
    return new SeriesNested(null);
  }
  
  public SeriesNested<A> withNewSeriesLike(EventSeries item) {
    return new SeriesNested(item);
  }
  
  public SeriesNested<A> editSeries() {
    return withNewSeriesLike(java.util.Optional.ofNullable(buildSeries()).orElse(null));
  }
  
  public SeriesNested<A> editOrNewSeries() {
    return withNewSeriesLike(java.util.Optional.ofNullable(buildSeries()).orElse(new EventSeriesBuilder().build()));
  }
  
  public SeriesNested<A> editOrNewSeriesLike(EventSeries item) {
    return withNewSeriesLike(java.util.Optional.ofNullable(buildSeries()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EventFluent that = (EventFluent) o;
    if (!java.util.Objects.equals(action, that.action)) return false;
  
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
  
    if (!java.util.Objects.equals(deprecatedCount, that.deprecatedCount)) return false;
  
    if (!java.util.Objects.equals(deprecatedFirstTimestamp, that.deprecatedFirstTimestamp)) return false;
  
    if (!java.util.Objects.equals(deprecatedLastTimestamp, that.deprecatedLastTimestamp)) return false;
  
    if (!java.util.Objects.equals(deprecatedSource, that.deprecatedSource)) return false;
  
    if (!java.util.Objects.equals(eventTime, that.eventTime)) return false;
  
    if (!java.util.Objects.equals(kind, that.kind)) return false;
  
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
  
    if (!java.util.Objects.equals(note, that.note)) return false;
  
    if (!java.util.Objects.equals(reason, that.reason)) return false;
  
    if (!java.util.Objects.equals(regarding, that.regarding)) return false;
  
    if (!java.util.Objects.equals(related, that.related)) return false;
  
    if (!java.util.Objects.equals(reportingController, that.reportingController)) return false;
  
    if (!java.util.Objects.equals(reportingInstance, that.reportingInstance)) return false;
  
    if (!java.util.Objects.equals(series, that.series)) return false;
  
    if (!java.util.Objects.equals(type, that.type)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(action,  apiVersion,  deprecatedCount,  deprecatedFirstTimestamp,  deprecatedLastTimestamp,  deprecatedSource,  eventTime,  kind,  metadata,  note,  reason,  regarding,  related,  reportingController,  reportingInstance,  series,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (deprecatedCount != null) { sb.append("deprecatedCount:"); sb.append(deprecatedCount + ","); }
    if (deprecatedFirstTimestamp != null) { sb.append("deprecatedFirstTimestamp:"); sb.append(deprecatedFirstTimestamp + ","); }
    if (deprecatedLastTimestamp != null) { sb.append("deprecatedLastTimestamp:"); sb.append(deprecatedLastTimestamp + ","); }
    if (deprecatedSource != null) { sb.append("deprecatedSource:"); sb.append(deprecatedSource + ","); }
    if (eventTime != null) { sb.append("eventTime:"); sb.append(eventTime + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (note != null) { sb.append("note:"); sb.append(note + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (regarding != null) { sb.append("regarding:"); sb.append(regarding + ","); }
    if (related != null) { sb.append("related:"); sb.append(related + ","); }
    if (reportingController != null) { sb.append("reportingController:"); sb.append(reportingController + ","); }
    if (reportingInstance != null) { sb.append("reportingInstance:"); sb.append(reportingInstance + ","); }
    if (series != null) { sb.append("series:"); sb.append(series + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) EventFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class RegardingNested<N> extends ObjectReferenceFluent<RegardingNested<N>> implements Nested<N>{
    RegardingNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) EventFluent.this.withRegarding(builder.build());
    }
    
    public N endRegarding() {
      return and();
    }
    
  
  }
  public class RelatedNested<N> extends ObjectReferenceFluent<RelatedNested<N>> implements Nested<N>{
    RelatedNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) EventFluent.this.withRelated(builder.build());
    }
    
    public N endRelated() {
      return and();
    }
    
  
  }
  public class SeriesNested<N> extends EventSeriesFluent<SeriesNested<N>> implements Nested<N>{
    SeriesNested(EventSeries item) {
      this.builder = new EventSeriesBuilder(this, item);
    }
    EventSeriesBuilder builder;
    
    public N and() {
      return (N) EventFluent.this.withSeries(builder.build());
    }
    
    public N endSeries() {
      return and();
    }
    
  
  }

}