package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class NetworkPolicySpecFluentImpl<A extends io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<A>{
  public NetworkPolicySpecFluentImpl() {
  }
  public NetworkPolicySpecFluentImpl(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance) {
    this.withEgress(instance.getEgress()); 
    this.withIngress(instance.getIngress()); 
    this.withPodSelector(instance.getPodSelector()); 
    this.withPolicyTypes(instance.getPolicyTypes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder> egress =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder> ingress =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder>();
  private io.fabric8.kubernetes.api.model.LabelSelectorBuilder podSelector;
  private java.util.List<java.lang.String> policyTypes = new java.util.ArrayList<java.lang.String>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToEgress(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder>();}
    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").add(index >= 0 ? index : _visitables.get("egress").size(), builder);this.egress.add(index >= 0 ? index : egress.size(), builder); return (A)this;
  }
  public A setToEgress(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder>();}
    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("egress").size()) { _visitables.get("egress").add(builder); } else { _visitables.get("egress").set(index, builder);}
    if (index < 0 || index >= egress.size()) { egress.add(builder); } else { egress.set(index, builder);}
     return (A)this;
  }
  public A addToEgress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule... items) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item : items) {io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  public A addAllToEgress(java.util.Collection<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule> items) {
    if (this.egress == null) {this.egress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item : items) {io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  public A removeFromEgress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule... items) {
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item : items) {io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
  }
  public A removeAllFromEgress(java.util.Collection<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule> items) {
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item : items) {io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEgress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder> predicate) {
    if (egress == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder> each = egress.iterator();
    final List visitables = _visitables.get("egress");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEgress instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule> getEgress() {
    return build(egress);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule> buildEgress() {
    return build(egress);
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule buildEgress(java.lang.Integer index) {
    return this.egress.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule buildFirstEgress() {
    return this.egress.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule buildLastEgress() {
    return this.egress.get(egress.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule buildMatchingEgress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder item: egress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingEgress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder item: egress) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgress(java.util.List<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule> egress) {
    if (this.egress != null) { _visitables.get("egress").removeAll(this.egress);}
    if (egress != null) {this.egress = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item : egress){this.addToEgress(item);}} else { this.egress = null;} return (A) this;
  }
  public A withEgress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule... egress) {
    if (this.egress != null) {this.egress.clear();}
    if (egress != null) {for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item :egress){ this.addToEgress(item);}} return (A) this;
  }
  public java.lang.Boolean hasEgress() {
    return egress != null && !egress.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<A> addNewEgress() {
    return new io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl.EgressNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item) {
    return new io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl.EgressNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item) {
    return new io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl.EgressNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<A> editEgress(java.lang.Integer index) {
    if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<A> editFirstEgress() {
    if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
    return setNewEgressLike(0, buildEgress(0));
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<A> editLastEgress() {
    int index = egress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<egress.size();i++) { 
    if (predicate.test(egress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
    return setNewEgressLike(index, buildEgress(index));
  }
  public A addToIngress(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder>();}
    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
  }
  public A setToIngress(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder>();}
    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
    if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
     return (A)this;
  }
  public A addToIngress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule... items) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item : items) {io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A addAllToIngress(java.util.Collection<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule> items) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item : items) {io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A removeFromIngress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule... items) {
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item : items) {io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeAllFromIngress(java.util.Collection<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule> items) {
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item : items) {io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIngress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule> getIngress() {
    return build(ingress);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule> buildIngress() {
    return build(ingress);
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule buildIngress(java.lang.Integer index) {
    return this.ingress.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule buildMatchingIngress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder item: ingress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingIngress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder item: ingress) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIngress(java.util.List<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule> ingress) {
    if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
    if (ingress != null) {this.ingress = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
  }
  public A withIngress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule... ingress) {
    if (this.ingress != null) {this.ingress.clear();}
    if (ingress != null) {for (io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item :ingress){ this.addToIngress(item);}} return (A) this;
  }
  public java.lang.Boolean hasIngress() {
    return ingress != null && !ingress.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<A> addNewIngress() {
    return new io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl.IngressNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item) {
    return new io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl.IngressNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item) {
    return new io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl.IngressNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<A> editIngress(java.lang.Integer index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  /**
   * This method has been deprecated, please use method buildPodSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.LabelSelector getPodSelector() {
    return this.podSelector!=null?this.podSelector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildPodSelector() {
    return this.podSelector!=null?this.podSelector.build():null;
  }
  public A withPodSelector(io.fabric8.kubernetes.api.model.LabelSelector podSelector) {
    _visitables.get("podSelector").remove(this.podSelector);
    if (podSelector!=null){ this.podSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(podSelector); _visitables.get("podSelector").add(this.podSelector);} return (A) this;
  }
  public java.lang.Boolean hasPodSelector() {
    return this.podSelector != null;
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector() {
    return new io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl.PodSelectorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluentImpl.PodSelectorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector() {
    return withNewPodSelectorLike(getPodSelector());
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector() {
    return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): item);
  }
  public A addToPolicyTypes(java.lang.Integer index,java.lang.String item) {
    if (this.policyTypes == null) {this.policyTypes = new java.util.ArrayList<java.lang.String>();}
    this.policyTypes.add(index, item);
    return (A)this;
  }
  public A setToPolicyTypes(java.lang.Integer index,java.lang.String item) {
    if (this.policyTypes == null) {this.policyTypes = new java.util.ArrayList<java.lang.String>();}
    this.policyTypes.set(index, item); return (A)this;
  }
  public A addToPolicyTypes(java.lang.String... items) {
    if (this.policyTypes == null) {this.policyTypes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.policyTypes.add(item);} return (A)this;
  }
  public A addAllToPolicyTypes(java.util.Collection<java.lang.String> items) {
    if (this.policyTypes == null) {this.policyTypes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.policyTypes.add(item);} return (A)this;
  }
  public A removeFromPolicyTypes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.policyTypes!= null){ this.policyTypes.remove(item);}} return (A)this;
  }
  public A removeAllFromPolicyTypes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.policyTypes!= null){ this.policyTypes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getPolicyTypes() {
    return this.policyTypes;
  }
  public java.lang.String getPolicyType(java.lang.Integer index) {
    return this.policyTypes.get(index);
  }
  public java.lang.String getFirstPolicyType() {
    return this.policyTypes.get(0);
  }
  public java.lang.String getLastPolicyType() {
    return this.policyTypes.get(policyTypes.size() - 1);
  }
  public java.lang.String getMatchingPolicyType(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: policyTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingPolicyType(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: policyTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPolicyTypes(java.util.List<java.lang.String> policyTypes) {
    if (policyTypes != null) {this.policyTypes = new java.util.ArrayList(); for (java.lang.String item : policyTypes){this.addToPolicyTypes(item);}} else { this.policyTypes = null;} return (A) this;
  }
  public A withPolicyTypes(java.lang.String... policyTypes) {
    if (this.policyTypes != null) {this.policyTypes.clear();}
    if (policyTypes != null) {for (java.lang.String item :policyTypes){ this.addToPolicyTypes(item);}} return (A) this;
  }
  public java.lang.Boolean hasPolicyTypes() {
    return policyTypes != null && !policyTypes.isEmpty();
  }
  public A addNewPolicyType(java.lang.String arg0) {
    return (A)addToPolicyTypes(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkPolicySpecFluentImpl that = (NetworkPolicySpecFluentImpl) o;
    if (egress != null ? !egress.equals(that.egress) :that.egress != null) return false;
    if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
    if (podSelector != null ? !podSelector.equals(that.podSelector) :that.podSelector != null) return false;
    if (policyTypes != null ? !policyTypes.equals(that.policyTypes) :that.policyTypes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(egress,  ingress,  podSelector,  policyTypes,  additionalProperties,  super.hashCode());
  }
  public class EgressNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluentImpl<io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<N>> implements io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.EgressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EgressNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder(this, item);
    }
    EgressNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder(this);
    }
    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkPolicySpecFluentImpl.this.setToEgress(index,builder.build());
    }
    public N endEgress() {
      return and();
    }
    
  }
  public class IngressNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleFluentImpl<io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<N>> implements io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.IngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder(this, item);
    }
    IngressNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder(this);
    }
    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkPolicySpecFluentImpl.this.setToIngress(index,builder.build());
    }
    public N endIngress() {
      return and();
    }
    
  }
  public class PodSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.PodSelectorNested<N>> implements io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent.PodSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PodSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    PodSelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) NetworkPolicySpecFluentImpl.this.withPodSelector(builder.build());
    }
    public N endPodSelector() {
      return and();
    }
    
  }
  
}