package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Long;
import java.lang.Object;

public class DaemonSetSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<A> {

    private java.lang.Integer minReadySeconds;
    private java.lang.Integer revisionHistoryLimit;
    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder selector;
    private io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder template;
    private java.lang.Long templateGeneration;
    private io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyBuilder updateStrategy;

    public DaemonSetSpecFluentImpl() {
    }

    public DaemonSetSpecFluentImpl(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds()); 
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
        this.withSelector(instance.getSelector()); 
        this.withTemplate(instance.getTemplate()); 
        this.withTemplateGeneration(instance.getTemplateGeneration()); 
        this.withUpdateStrategy(instance.getUpdateStrategy()); 
    }

    public java.lang.Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(java.lang.Integer minReadySeconds) {
        this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public java.lang.Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public java.lang.Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(java.lang.Integer revisionHistoryLimit) {
        this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public java.lang.Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl.SelectorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl.SelectorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.PodTemplateSpec getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl.TemplateNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
        return new io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public java.lang.Long getTemplateGeneration() {
        return this.templateGeneration;
    }

    public A withTemplateGeneration(java.lang.Long templateGeneration) {
        this.templateGeneration=templateGeneration; return (A) this;
    }

    public java.lang.Boolean hasTemplateGeneration() {
        return this.templateGeneration != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildUpdateStrategy instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy!=null?this.updateStrategy.build():null;
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy!=null?this.updateStrategy.build():null;
    }

    public A withUpdateStrategy(io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategy updateStrategy) {
        _visitables.get("updateStrategy").remove(this.updateStrategy);
        if (updateStrategy!=null){ this.updateStrategy= new io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} return (A) this;
    }

    public java.lang.Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl.UpdateStrategyNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategy item) {
        return new io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl.UpdateStrategyNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return withNewUpdateStrategyLike(getUpdateStrategy());
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): new io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategy item) {
        return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DaemonSetSpecFluentImpl that = (DaemonSetSpecFluentImpl) o;
        if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
        if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        if (templateGeneration != null ? !templateGeneration.equals(that.templateGeneration) :that.templateGeneration != null) return false;
        if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(minReadySeconds,  revisionHistoryLimit,  selector,  template,  templateGeneration,  updateStrategy,  super.hashCode());
    }

    public class SelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<N>> implements io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) DaemonSetSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


    public class TemplateNestedImpl<N> extends io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl<io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<N>> implements io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder builder;

            TemplateNestedImpl(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
                this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) DaemonSetSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


    public class UpdateStrategyNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyFluentImpl<io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<N>> implements io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyBuilder builder;

            UpdateStrategyNestedImpl(io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategy item) {
                this.builder = new io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyBuilder(this, item);
                        
            }

            UpdateStrategyNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) DaemonSetSpecFluentImpl.this.withUpdateStrategy(builder.build());
            }

            public N endUpdateStrategy() {
                return and();
            }
    }


}
