package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DaemonSetListBuilder extends DaemonSetListFluent<DaemonSetListBuilder> implements VisitableBuilder<DaemonSetList,DaemonSetListBuilder>{
  public DaemonSetListBuilder() {
    this(new DaemonSetList());
  }
  
  public DaemonSetListBuilder(DaemonSetListFluent<?> fluent) {
    this(fluent, new DaemonSetList());
  }
  
  public DaemonSetListBuilder(DaemonSetListFluent<?> fluent,DaemonSetList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DaemonSetListBuilder(DaemonSetList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DaemonSetListFluent<?> fluent;
  
  public DaemonSetList build() {
    DaemonSetList buildable = new DaemonSetList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}