package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetSpecBuilder extends ReplicaSetSpecFluentImpl<ReplicaSetSpecBuilder> implements VisitableBuilder<ReplicaSetSpec,ReplicaSetSpecBuilder>{
  public ReplicaSetSpecBuilder() {
    this(false);
  }
  public ReplicaSetSpecBuilder(Boolean validationEnabled) {
    this(new ReplicaSetSpec(), validationEnabled);
  }
  public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicaSetSpec(), validationEnabled);
  }
  public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent,ReplicaSetSpec instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent,ReplicaSetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetSpecBuilder(ReplicaSetSpec instance) {
    this(instance,false);
  }
  public ReplicaSetSpecBuilder(ReplicaSetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReplicaSetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicaSetSpec build() {
    ReplicaSetSpec buildable = new ReplicaSetSpec(fluent.getMinReadySeconds(),fluent.getReplicas(),fluent.getSelector(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}