package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface DaemonSetStatusFluent<A extends DaemonSetStatusFluent<A>> extends Fluent<A>{
  public Integer getCollisionCount();
  public A withCollisionCount(Integer collisionCount);
  public Boolean hasCollisionCount();
  public A addToConditions(int index,DaemonSetCondition item);
  public A setToConditions(int index,DaemonSetCondition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.extensions.DaemonSetCondition... items);
  public A addAllToConditions(Collection<DaemonSetCondition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.extensions.DaemonSetCondition... items);
  public A removeAllFromConditions(Collection<DaemonSetCondition> items);
  public A removeMatchingFromConditions(Predicate<DaemonSetConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DaemonSetCondition> getConditions();
  public List<DaemonSetCondition> buildConditions();
  public DaemonSetCondition buildCondition(int index);
  public DaemonSetCondition buildFirstCondition();
  public DaemonSetCondition buildLastCondition();
  public DaemonSetCondition buildMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate);
  public A withConditions(List<DaemonSetCondition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.extensions.DaemonSetCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public DaemonSetStatusFluent.ConditionsNested<A> addNewCondition();
  public DaemonSetStatusFluent.ConditionsNested<A> addNewConditionLike(DaemonSetCondition item);
  public DaemonSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,DaemonSetCondition item);
  public DaemonSetStatusFluent.ConditionsNested<A> editCondition(int index);
  public DaemonSetStatusFluent.ConditionsNested<A> editFirstCondition();
  public DaemonSetStatusFluent.ConditionsNested<A> editLastCondition();
  public DaemonSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate);
  public Integer getCurrentNumberScheduled();
  public A withCurrentNumberScheduled(Integer currentNumberScheduled);
  public Boolean hasCurrentNumberScheduled();
  public Integer getDesiredNumberScheduled();
  public A withDesiredNumberScheduled(Integer desiredNumberScheduled);
  public Boolean hasDesiredNumberScheduled();
  public Integer getNumberAvailable();
  public A withNumberAvailable(Integer numberAvailable);
  public Boolean hasNumberAvailable();
  public Integer getNumberMisscheduled();
  public A withNumberMisscheduled(Integer numberMisscheduled);
  public Boolean hasNumberMisscheduled();
  public Integer getNumberReady();
  public A withNumberReady(Integer numberReady);
  public Boolean hasNumberReady();
  public Integer getNumberUnavailable();
  public A withNumberUnavailable(Integer numberUnavailable);
  public Boolean hasNumberUnavailable();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public Integer getUpdatedNumberScheduled();
  public A withUpdatedNumberScheduled(Integer updatedNumberScheduled);
  public Boolean hasUpdatedNumberScheduled();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,DaemonSetConditionFluent<DaemonSetStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  
}