package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPBlockBuilder extends IPBlockFluentImpl<IPBlockBuilder> implements VisitableBuilder<IPBlock,IPBlockBuilder>{
  public IPBlockBuilder() {
    this(false);
  }
  public IPBlockBuilder(Boolean validationEnabled) {
    this(new IPBlock(), validationEnabled);
  }
  public IPBlockBuilder(IPBlockFluent<?> fluent) {
    this(fluent, false);
  }
  public IPBlockBuilder(IPBlockFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPBlock(), validationEnabled);
  }
  public IPBlockBuilder(IPBlockFluent<?> fluent,IPBlock instance) {
    this(fluent, instance, false);
  }
  public IPBlockBuilder(IPBlockFluent<?> fluent,IPBlock instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCidr(instance.getCidr());
      fluent.withExcept(instance.getExcept());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IPBlockBuilder(IPBlock instance) {
    this(instance,false);
  }
  public IPBlockBuilder(IPBlock instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCidr(instance.getCidr());
      this.withExcept(instance.getExcept());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IPBlockFluent<?> fluent;
  Boolean validationEnabled;
  public IPBlock build() {
    IPBlock buildable = new IPBlock(fluent.getCidr(),fluent.getExcept());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}