package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressListBuilder extends IngressListFluent<IngressListBuilder> implements VisitableBuilder<IngressList,IngressListBuilder>{
  public IngressListBuilder() {
    this(false);
  }
  public IngressListBuilder(Boolean validationEnabled) {
    this(new IngressList(), validationEnabled);
  }
  public IngressListBuilder(IngressListFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressListBuilder(IngressListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressList(), validationEnabled);
  }
  public IngressListBuilder(IngressListFluent<?> fluent,IngressList instance) {
    this(fluent, instance, false);
  }
  public IngressListBuilder(IngressListFluent<?> fluent,IngressList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressListBuilder(IngressList instance) {
    this(instance,false);
  }
  public IngressListBuilder(IngressList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressListFluent<?> fluent;
  Boolean validationEnabled;
  public IngressList build() {
    IngressList buildable = new IngressList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}