package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyEgressRuleBuilder extends NetworkPolicyEgressRuleFluent<NetworkPolicyEgressRuleBuilder> implements VisitableBuilder<NetworkPolicyEgressRule,NetworkPolicyEgressRuleBuilder>{
  public NetworkPolicyEgressRuleBuilder() {
    this(false);
  }
  public NetworkPolicyEgressRuleBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyEgressRule(), validationEnabled);
  }
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkPolicyEgressRule(), validationEnabled);
  }
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent,NetworkPolicyEgressRule instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent,NetworkPolicyEgressRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NetworkPolicyEgressRule());

    if (instance != null) {
      fluent.withPorts(instance.getPorts());
      fluent.withTo(instance.getTo());
      fluent.withPorts(instance.getPorts());
      fluent.withTo(instance.getTo());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRule instance) {
    this(instance,false);
  }
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NetworkPolicyEgressRule());

    if (instance != null) {
      this.withPorts(instance.getPorts());
      this.withTo(instance.getTo());
      this.withPorts(instance.getPorts());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkPolicyEgressRuleFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkPolicyEgressRule build() {
    NetworkPolicyEgressRule buildable = new NetworkPolicyEgressRule(fluent.buildPorts(),fluent.buildTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}