package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetBuilder extends ReplicaSetFluent<ReplicaSetBuilder> implements VisitableBuilder<ReplicaSet,ReplicaSetBuilder>{
  public ReplicaSetBuilder() {
    this(false);
  }
  public ReplicaSetBuilder(Boolean validationEnabled) {
    this(new ReplicaSet(), validationEnabled);
  }
  public ReplicaSetBuilder(ReplicaSetFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetBuilder(ReplicaSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicaSet(), validationEnabled);
  }
  public ReplicaSetBuilder(ReplicaSetFluent<?> fluent,ReplicaSet instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetBuilder(ReplicaSetFluent<?> fluent,ReplicaSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ReplicaSet());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetBuilder(ReplicaSet instance) {
    this(instance,false);
  }
  public ReplicaSetBuilder(ReplicaSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ReplicaSet());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReplicaSetFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicaSet build() {
    ReplicaSet buildable = new ReplicaSet(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}