package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetListBuilder extends ReplicaSetListFluent<ReplicaSetListBuilder> implements VisitableBuilder<ReplicaSetList,ReplicaSetListBuilder>{
  public ReplicaSetListBuilder() {
    this(false);
  }
  public ReplicaSetListBuilder(Boolean validationEnabled) {
    this(new ReplicaSetList(), validationEnabled);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicaSetList(), validationEnabled);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent,ReplicaSetList instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent,ReplicaSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ReplicaSetList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetListBuilder(ReplicaSetList instance) {
    this(instance,false);
  }
  public ReplicaSetListBuilder(ReplicaSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ReplicaSetList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReplicaSetListFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicaSetList build() {
    ReplicaSetList buildable = new ReplicaSetList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}