package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReplicaSetStatusFluent<A extends ReplicaSetStatusFluent<A>> extends BaseFluent<A>{
  public ReplicaSetStatusFluent() {
  }
  public ReplicaSetStatusFluent(ReplicaSetStatus instance) {
    instance = (instance != null ? instance : new ReplicaSetStatus());

    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withConditions(instance.getConditions());
      this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withConditions(instance.getConditions());
      this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Integer availableReplicas;
  private ArrayList<ReplicaSetConditionBuilder> conditions = new ArrayList<ReplicaSetConditionBuilder>();
  private Integer fullyLabeledReplicas;
  private Long observedGeneration;
  private Integer readyReplicas;
  private Integer replicas;
  private Map<String,Object> additionalProperties;
  public Integer getAvailableReplicas() {
    return this.availableReplicas;
  }
  public A withAvailableReplicas(Integer availableReplicas) {
    this.availableReplicas=availableReplicas; return (A) this;
  }
  public boolean hasAvailableReplicas() {
    return this.availableReplicas != null;
  }
  public A addToConditions(int index,ReplicaSetCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ReplicaSetConditionBuilder>();}
    ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ReplicaSetCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ReplicaSetConditionBuilder>();}
    ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ReplicaSetConditionBuilder>();}
    for (ReplicaSetCondition item : items) {ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ReplicaSetCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ReplicaSetConditionBuilder>();}
    for (ReplicaSetCondition item : items) {ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition... items) {
    if (this.conditions == null) return (A)this;
    for (ReplicaSetCondition item : items) {ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeAllFromConditions(Collection<ReplicaSetCondition> items) {
    if (this.conditions == null) return (A)this;
    for (ReplicaSetCondition item : items) {ReplicaSetConditionBuilder builder = new ReplicaSetConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ReplicaSetConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ReplicaSetConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ReplicaSetConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ReplicaSetCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ReplicaSetCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ReplicaSetCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ReplicaSetCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ReplicaSetCondition buildMatchingCondition(Predicate<ReplicaSetConditionBuilder> predicate) {
    for (ReplicaSetConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCondition(Predicate<ReplicaSetConditionBuilder> predicate) {
    for (ReplicaSetConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ReplicaSetCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ReplicaSetCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ReplicaSetCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ReplicaSetCondition(lastTransitionTime, message, reason, status, type));
  }
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  public ConditionsNested<A> addNewConditionLike(ReplicaSetCondition item) {
    return new ConditionsNested(-1, item);
  }
  public ConditionsNested<A> setNewConditionLike(int index,ReplicaSetCondition item) {
    return new ConditionsNested(index, item);
  }
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editMatchingCondition(Predicate<ReplicaSetConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Integer getFullyLabeledReplicas() {
    return this.fullyLabeledReplicas;
  }
  public A withFullyLabeledReplicas(Integer fullyLabeledReplicas) {
    this.fullyLabeledReplicas=fullyLabeledReplicas; return (A) this;
  }
  public boolean hasFullyLabeledReplicas() {
    return this.fullyLabeledReplicas != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  public A withReadyReplicas(Integer readyReplicas) {
    this.readyReplicas=readyReplicas; return (A) this;
  }
  public boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReplicaSetStatusFluent that = (ReplicaSetStatusFluent) o;
    if (!java.util.Objects.equals(availableReplicas, that.availableReplicas)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(fullyLabeledReplicas, that.fullyLabeledReplicas)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(readyReplicas, that.readyReplicas)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableReplicas,  conditions,  fullyLabeledReplicas,  observedGeneration,  readyReplicas,  replicas,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableReplicas != null) { sb.append("availableReplicas:"); sb.append(availableReplicas + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (fullyLabeledReplicas != null) { sb.append("fullyLabeledReplicas:"); sb.append(fullyLabeledReplicas + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (readyReplicas != null) { sb.append("readyReplicas:"); sb.append(readyReplicas + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends ReplicaSetConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,ReplicaSetCondition item) {
      this.index = index;
      this.builder = new ReplicaSetConditionBuilder(this, item);
    }
    ReplicaSetConditionBuilder builder;
    int index;
    public N and() {
      return (N) ReplicaSetStatusFluent.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}