package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RollingUpdateDaemonSetBuilder extends RollingUpdateDaemonSetFluent<RollingUpdateDaemonSetBuilder> implements VisitableBuilder<RollingUpdateDaemonSet,RollingUpdateDaemonSetBuilder>{
  public RollingUpdateDaemonSetBuilder() {
    this(false);
  }
  public RollingUpdateDaemonSetBuilder(Boolean validationEnabled) {
    this(new RollingUpdateDaemonSet(), validationEnabled);
  }
  public RollingUpdateDaemonSetBuilder(RollingUpdateDaemonSetFluent<?> fluent) {
    this(fluent, false);
  }
  public RollingUpdateDaemonSetBuilder(RollingUpdateDaemonSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RollingUpdateDaemonSet(), validationEnabled);
  }
  public RollingUpdateDaemonSetBuilder(RollingUpdateDaemonSetFluent<?> fluent,RollingUpdateDaemonSet instance) {
    this(fluent, instance, false);
  }
  public RollingUpdateDaemonSetBuilder(RollingUpdateDaemonSetFluent<?> fluent,RollingUpdateDaemonSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RollingUpdateDaemonSet());

    if (instance != null) {
      fluent.withMaxSurge(instance.getMaxSurge());
      fluent.withMaxUnavailable(instance.getMaxUnavailable());
      fluent.withMaxSurge(instance.getMaxSurge());
      fluent.withMaxUnavailable(instance.getMaxUnavailable());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RollingUpdateDaemonSetBuilder(RollingUpdateDaemonSet instance) {
    this(instance,false);
  }
  public RollingUpdateDaemonSetBuilder(RollingUpdateDaemonSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RollingUpdateDaemonSet());

    if (instance != null) {
      this.withMaxSurge(instance.getMaxSurge());
      this.withMaxUnavailable(instance.getMaxUnavailable());
      this.withMaxSurge(instance.getMaxSurge());
      this.withMaxUnavailable(instance.getMaxUnavailable());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RollingUpdateDaemonSetFluent<?> fluent;
  Boolean validationEnabled;
  public RollingUpdateDaemonSet build() {
    RollingUpdateDaemonSet buildable = new RollingUpdateDaemonSet(fluent.buildMaxSurge(),fluent.buildMaxUnavailable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}