package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkPolicySpecFluent<A extends NetworkPolicySpecFluent<A>> extends BaseFluent<A>{
  public NetworkPolicySpecFluent() {
  }
  
  public NetworkPolicySpecFluent(NetworkPolicySpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<NetworkPolicyEgressRuleBuilder> egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
  private ArrayList<NetworkPolicyIngressRuleBuilder> ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
  private LabelSelectorBuilder podSelector;
  private List<String> policyTypes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkPolicySpec instance) {
    instance = (instance != null ? instance : new NetworkPolicySpec());
  
    if (instance != null) {
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToEgress(int index,NetworkPolicyEgressRule item) {
    if (this.egress == null) {this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();}
    NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
    if (index < 0 || index >= egress.size()) { _visitables.get("egress").add(builder); egress.add(builder); } else { _visitables.get("egress").add(index, builder); egress.add(index, builder);}
    return (A)this;
  }
  
  public A setToEgress(int index,NetworkPolicyEgressRule item) {
    if (this.egress == null) {this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();}
    NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
    if (index < 0 || index >= egress.size()) { _visitables.get("egress").add(builder); egress.add(builder); } else { _visitables.get("egress").set(index, builder); egress.set(index, builder);}
    return (A)this;
  }
  
  public A addToEgress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule... items) {
    if (this.egress == null) {this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();}
    for (NetworkPolicyEgressRule item : items) {NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  
  public A addAllToEgress(Collection<NetworkPolicyEgressRule> items) {
    if (this.egress == null) {this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();}
    for (NetworkPolicyEgressRule item : items) {NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  
  public A removeFromEgress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule... items) {
    if (this.egress == null) return (A)this;
    for (NetworkPolicyEgressRule item : items) {NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").remove(builder); this.egress.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEgress(Collection<NetworkPolicyEgressRule> items) {
    if (this.egress == null) return (A)this;
    for (NetworkPolicyEgressRule item : items) {NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);_visitables.get("egress").remove(builder); this.egress.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
    if (egress == null) return (A) this;
    final Iterator<NetworkPolicyEgressRuleBuilder> each = egress.iterator();
    final List visitables = _visitables.get("egress");
    while (each.hasNext()) {
      NetworkPolicyEgressRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NetworkPolicyEgressRule> buildEgress() {
    return egress != null ? build(egress) : null;
  }
  
  public NetworkPolicyEgressRule buildEgress(int index) {
    return this.egress.get(index).build();
  }
  
  public NetworkPolicyEgressRule buildFirstEgress() {
    return this.egress.get(0).build();
  }
  
  public NetworkPolicyEgressRule buildLastEgress() {
    return this.egress.get(egress.size() - 1).build();
  }
  
  public NetworkPolicyEgressRule buildMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
    for (NetworkPolicyEgressRuleBuilder item: egress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
    for (NetworkPolicyEgressRuleBuilder item: egress) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withEgress(List<NetworkPolicyEgressRule> egress) {
    if (this.egress != null) { _visitables.get("egress").clear();}
    if (egress != null) {this.egress = new ArrayList(); for (NetworkPolicyEgressRule item : egress){this.addToEgress(item);}} else { this.egress = null;} return (A) this;
  }
  
  public A withEgress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule... egress) {
    if (this.egress != null) {this.egress.clear(); _visitables.remove("egress"); }
    if (egress != null) {for (NetworkPolicyEgressRule item :egress){ this.addToEgress(item);}} return (A) this;
  }
  
  public boolean hasEgress() {
    return egress != null && !egress.isEmpty();
  }
  
  public EgressNested<A> addNewEgress() {
    return new EgressNested(-1, null);
  }
  
  public EgressNested<A> addNewEgressLike(NetworkPolicyEgressRule item) {
    return new EgressNested(-1, item);
  }
  
  public EgressNested<A> setNewEgressLike(int index,NetworkPolicyEgressRule item) {
    return new EgressNested(index, item);
  }
  
  public EgressNested<A> editEgress(int index) {
    if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
    return setNewEgressLike(index, buildEgress(index));
  }
  
  public EgressNested<A> editFirstEgress() {
    if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
    return setNewEgressLike(0, buildEgress(0));
  }
  
  public EgressNested<A> editLastEgress() {
    int index = egress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
    return setNewEgressLike(index, buildEgress(index));
  }
  
  public EgressNested<A> editMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<egress.size();i++) { 
    if (predicate.test(egress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
    return setNewEgressLike(index, buildEgress(index));
  }
  
  public A addToIngress(int index,NetworkPolicyIngressRule item) {
    if (this.ingress == null) {this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();}
    NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
    if (index < 0 || index >= ingress.size()) { _visitables.get("ingress").add(builder); ingress.add(builder); } else { _visitables.get("ingress").add(index, builder); ingress.add(index, builder);}
    return (A)this;
  }
  
  public A setToIngress(int index,NetworkPolicyIngressRule item) {
    if (this.ingress == null) {this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();}
    NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
    if (index < 0 || index >= ingress.size()) { _visitables.get("ingress").add(builder); ingress.add(builder); } else { _visitables.get("ingress").set(index, builder); ingress.set(index, builder);}
    return (A)this;
  }
  
  public A addToIngress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule... items) {
    if (this.ingress == null) {this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();}
    for (NetworkPolicyIngressRule item : items) {NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  
  public A addAllToIngress(Collection<NetworkPolicyIngressRule> items) {
    if (this.ingress == null) {this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();}
    for (NetworkPolicyIngressRule item : items) {NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  
  public A removeFromIngress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule... items) {
    if (this.ingress == null) return (A)this;
    for (NetworkPolicyIngressRule item : items) {NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").remove(builder); this.ingress.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items) {
    if (this.ingress == null) return (A)this;
    for (NetworkPolicyIngressRule item : items) {NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.get("ingress").remove(builder); this.ingress.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<NetworkPolicyIngressRuleBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      NetworkPolicyIngressRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NetworkPolicyIngressRule> buildIngress() {
    return ingress != null ? build(ingress) : null;
  }
  
  public NetworkPolicyIngressRule buildIngress(int index) {
    return this.ingress.get(index).build();
  }
  
  public NetworkPolicyIngressRule buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  
  public NetworkPolicyIngressRule buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  
  public NetworkPolicyIngressRule buildMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
    for (NetworkPolicyIngressRuleBuilder item: ingress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
    for (NetworkPolicyIngressRuleBuilder item: ingress) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withIngress(List<NetworkPolicyIngressRule> ingress) {
    if (this.ingress != null) { _visitables.get("ingress").clear();}
    if (ingress != null) {this.ingress = new ArrayList(); for (NetworkPolicyIngressRule item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
  }
  
  public A withIngress(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule... ingress) {
    if (this.ingress != null) {this.ingress.clear(); _visitables.remove("ingress"); }
    if (ingress != null) {for (NetworkPolicyIngressRule item :ingress){ this.addToIngress(item);}} return (A) this;
  }
  
  public boolean hasIngress() {
    return ingress != null && !ingress.isEmpty();
  }
  
  public IngressNested<A> addNewIngress() {
    return new IngressNested(-1, null);
  }
  
  public IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item) {
    return new IngressNested(-1, item);
  }
  
  public IngressNested<A> setNewIngressLike(int index,NetworkPolicyIngressRule item) {
    return new IngressNested(index, item);
  }
  
  public IngressNested<A> editIngress(int index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  
  public IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public IngressNested<A> editMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public LabelSelector buildPodSelector() {
    return this.podSelector!=null ?this.podSelector.build():null;
  }
  
  public A withPodSelector(LabelSelector podSelector) {
    _visitables.get("podSelector").remove(this.podSelector);
    if (podSelector!=null){ this.podSelector= new LabelSelectorBuilder(podSelector); _visitables.get("podSelector").add(this.podSelector);} else { this.podSelector = null; _visitables.get("podSelector").remove(this.podSelector); } return (A) this;
  }
  
  public boolean hasPodSelector() {
    return this.podSelector != null;
  }
  
  public PodSelectorNested<A> withNewPodSelector() {
    return new PodSelectorNested(null);
  }
  
  public PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
    return new PodSelectorNested(item);
  }
  
  public PodSelectorNested<A> editPodSelector() {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(null));
  }
  
  public PodSelectorNested<A> editOrNewPodSelector() {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
    return withNewPodSelectorLike(java.util.Optional.ofNullable(buildPodSelector()).orElse(item));
  }
  
  public A addToPolicyTypes(int index,String item) {
    if (this.policyTypes == null) {this.policyTypes = new ArrayList<String>();}
    this.policyTypes.add(index, item);
    return (A)this;
  }
  
  public A setToPolicyTypes(int index,String item) {
    if (this.policyTypes == null) {this.policyTypes = new ArrayList<String>();}
    this.policyTypes.set(index, item); return (A)this;
  }
  
  public A addToPolicyTypes(java.lang.String... items) {
    if (this.policyTypes == null) {this.policyTypes = new ArrayList<String>();}
    for (String item : items) {this.policyTypes.add(item);} return (A)this;
  }
  
  public A addAllToPolicyTypes(Collection<String> items) {
    if (this.policyTypes == null) {this.policyTypes = new ArrayList<String>();}
    for (String item : items) {this.policyTypes.add(item);} return (A)this;
  }
  
  public A removeFromPolicyTypes(java.lang.String... items) {
    if (this.policyTypes == null) return (A)this;
    for (String item : items) { this.policyTypes.remove(item);} return (A)this;
  }
  
  public A removeAllFromPolicyTypes(Collection<String> items) {
    if (this.policyTypes == null) return (A)this;
    for (String item : items) { this.policyTypes.remove(item);} return (A)this;
  }
  
  public List<String> getPolicyTypes() {
    return this.policyTypes;
  }
  
  public String getPolicyType(int index) {
    return this.policyTypes.get(index);
  }
  
  public String getFirstPolicyType() {
    return this.policyTypes.get(0);
  }
  
  public String getLastPolicyType() {
    return this.policyTypes.get(policyTypes.size() - 1);
  }
  
  public String getMatchingPolicyType(Predicate<String> predicate) {
    for (String item: policyTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingPolicyType(Predicate<String> predicate) {
    for (String item: policyTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withPolicyTypes(List<String> policyTypes) {
    if (policyTypes != null) {this.policyTypes = new ArrayList(); for (String item : policyTypes){this.addToPolicyTypes(item);}} else { this.policyTypes = null;} return (A) this;
  }
  
  public A withPolicyTypes(java.lang.String... policyTypes) {
    if (this.policyTypes != null) {this.policyTypes.clear(); _visitables.remove("policyTypes"); }
    if (policyTypes != null) {for (String item :policyTypes){ this.addToPolicyTypes(item);}} return (A) this;
  }
  
  public boolean hasPolicyTypes() {
    return policyTypes != null && !policyTypes.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicySpecFluent that = (NetworkPolicySpecFluent) o;
    if (!java.util.Objects.equals(egress, that.egress)) return false;
  
    if (!java.util.Objects.equals(ingress, that.ingress)) return false;
  
    if (!java.util.Objects.equals(podSelector, that.podSelector)) return false;
  
    if (!java.util.Objects.equals(policyTypes, that.policyTypes)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(egress,  ingress,  podSelector,  policyTypes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (egress != null && !egress.isEmpty()) { sb.append("egress:"); sb.append(egress + ","); }
    if (ingress != null && !ingress.isEmpty()) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (podSelector != null) { sb.append("podSelector:"); sb.append(podSelector + ","); }
    if (policyTypes != null && !policyTypes.isEmpty()) { sb.append("policyTypes:"); sb.append(policyTypes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EgressNested<N> extends NetworkPolicyEgressRuleFluent<EgressNested<N>> implements Nested<N>{
    EgressNested(int index,NetworkPolicyEgressRule item) {
      this.index = index;
      this.builder = new NetworkPolicyEgressRuleBuilder(this, item);
    }
    NetworkPolicyEgressRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkPolicySpecFluent.this.setToEgress(index,builder.build());
    }
    
    public N endEgress() {
      return and();
    }
    
  
  }
  public class IngressNested<N> extends NetworkPolicyIngressRuleFluent<IngressNested<N>> implements Nested<N>{
    IngressNested(int index,NetworkPolicyIngressRule item) {
      this.index = index;
      this.builder = new NetworkPolicyIngressRuleBuilder(this, item);
    }
    NetworkPolicyIngressRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkPolicySpecFluent.this.setToIngress(index,builder.build());
    }
    
    public N endIngress() {
      return and();
    }
    
  
  }
  public class PodSelectorNested<N> extends LabelSelectorFluent<PodSelectorNested<N>> implements Nested<N>{
    PodSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) NetworkPolicySpecFluent.this.withPodSelector(builder.build());
    }
    
    public N endPodSelector() {
      return and();
    }
    
  
  }

}