package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DaemonSetBuilder extends DaemonSetFluent<DaemonSetBuilder> implements VisitableBuilder<DaemonSet,DaemonSetBuilder>{
  public DaemonSetBuilder() {
    this(new DaemonSet());
  }
  
  public DaemonSetBuilder(DaemonSetFluent<?> fluent) {
    this(fluent, new DaemonSet());
  }
  
  public DaemonSetBuilder(DaemonSetFluent<?> fluent,DaemonSet instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DaemonSetBuilder(DaemonSet instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DaemonSetFluent<?> fluent;
  
  public DaemonSet build() {
    DaemonSet buildable = new DaemonSet(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}