package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressSpecBuilder extends IngressSpecFluent<IngressSpecBuilder> implements VisitableBuilder<IngressSpec,IngressSpecBuilder>{
  public IngressSpecBuilder() {
    this(new IngressSpec());
  }
  
  public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
    this(fluent, new IngressSpec());
  }
  
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,IngressSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressSpecBuilder(IngressSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressSpecFluent<?> fluent;
  
  public IngressSpec build() {
    IngressSpec buildable = new IngressSpec(fluent.buildBackend(),fluent.buildRules(),fluent.buildTls());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}