/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetCondition;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetConditionBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetConditionFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DaemonSetStatusFluent<A extends DaemonSetStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer collisionCount;
    private ArrayList<DaemonSetConditionBuilder> conditions = new ArrayList();
    private Integer currentNumberScheduled;
    private Integer desiredNumberScheduled;
    private Integer numberAvailable;
    private Integer numberMisscheduled;
    private Integer numberReady;
    private Integer numberUnavailable;
    private Long observedGeneration;
    private Integer updatedNumberScheduled;

    public DaemonSetStatusFluent() {
    }

    public DaemonSetStatusFluent(DaemonSetStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<DaemonSetCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DaemonSetCondition item : items) {
            DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new DaemonSetCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewConditionLike(DaemonSetCondition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(DaemonSetCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DaemonSetCondition item : items) {
            DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, DaemonSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public DaemonSetCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<DaemonSetCondition> buildConditions() {
        return this.conditions != null ? DaemonSetStatusFluent.build(this.conditions) : null;
    }

    public DaemonSetCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public DaemonSetCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public DaemonSetCondition buildMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
        for (DaemonSetConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(DaemonSetStatus instance) {
        DaemonSetStatus daemonSetStatus = instance = instance != null ? instance : new DaemonSetStatus();
        if (instance != null) {
            this.withCollisionCount(instance.getCollisionCount());
            this.withConditions(instance.getConditions());
            this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
            this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
            this.withNumberAvailable(instance.getNumberAvailable());
            this.withNumberMisscheduled(instance.getNumberMisscheduled());
            this.withNumberReady(instance.getNumberReady());
            this.withNumberUnavailable(instance.getNumberUnavailable());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetStatusFluent that = (DaemonSetStatusFluent)((Object)o);
        if (!Objects.equals(this.collisionCount, that.collisionCount)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentNumberScheduled, that.currentNumberScheduled)) {
            return false;
        }
        if (!Objects.equals(this.desiredNumberScheduled, that.desiredNumberScheduled)) {
            return false;
        }
        if (!Objects.equals(this.numberAvailable, that.numberAvailable)) {
            return false;
        }
        if (!Objects.equals(this.numberMisscheduled, that.numberMisscheduled)) {
            return false;
        }
        if (!Objects.equals(this.numberReady, that.numberReady)) {
            return false;
        }
        if (!Objects.equals(this.numberUnavailable, that.numberUnavailable)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.updatedNumberScheduled, that.updatedNumberScheduled)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public Integer getCurrentNumberScheduled() {
        return this.currentNumberScheduled;
    }

    public Integer getDesiredNumberScheduled() {
        return this.desiredNumberScheduled;
    }

    public Integer getNumberAvailable() {
        return this.numberAvailable;
    }

    public Integer getNumberMisscheduled() {
        return this.numberMisscheduled;
    }

    public Integer getNumberReady() {
        return this.numberReady;
    }

    public Integer getNumberUnavailable() {
        return this.numberUnavailable;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public Integer getUpdatedNumberScheduled() {
        return this.updatedNumberScheduled;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasCurrentNumberScheduled() {
        return this.currentNumberScheduled != null;
    }

    public boolean hasDesiredNumberScheduled() {
        return this.desiredNumberScheduled != null;
    }

    public boolean hasMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
        for (DaemonSetConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNumberAvailable() {
        return this.numberAvailable != null;
    }

    public boolean hasNumberMisscheduled() {
        return this.numberMisscheduled != null;
    }

    public boolean hasNumberReady() {
        return this.numberReady != null;
    }

    public boolean hasNumberUnavailable() {
        return this.numberUnavailable != null;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasUpdatedNumberScheduled() {
        return this.updatedNumberScheduled != null;
    }

    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentNumberScheduled, this.desiredNumberScheduled, this.numberAvailable, this.numberMisscheduled, this.numberReady, this.numberUnavailable, this.observedGeneration, this.updatedNumberScheduled, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<DaemonSetCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (DaemonSetCondition item : items) {
            DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(DaemonSetCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (DaemonSetCondition item : items) {
            DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<DaemonSetConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<DaemonSetConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            DaemonSetConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, DaemonSetCondition item) {
        return new ConditionsNested(index, item);
    }

    public A setToConditions(int index, DaemonSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.collisionCount != null) {
            sb.append("collisionCount:");
            sb.append(this.collisionCount);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.currentNumberScheduled != null) {
            sb.append("currentNumberScheduled:");
            sb.append(this.currentNumberScheduled);
            sb.append(",");
        }
        if (this.desiredNumberScheduled != null) {
            sb.append("desiredNumberScheduled:");
            sb.append(this.desiredNumberScheduled);
            sb.append(",");
        }
        if (this.numberAvailable != null) {
            sb.append("numberAvailable:");
            sb.append(this.numberAvailable);
            sb.append(",");
        }
        if (this.numberMisscheduled != null) {
            sb.append("numberMisscheduled:");
            sb.append(this.numberMisscheduled);
            sb.append(",");
        }
        if (this.numberReady != null) {
            sb.append("numberReady:");
            sb.append(this.numberReady);
            sb.append(",");
        }
        if (this.numberUnavailable != null) {
            sb.append("numberUnavailable:");
            sb.append(this.numberUnavailable);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.updatedNumberScheduled != null) {
            sb.append("updatedNumberScheduled:");
            sb.append(this.updatedNumberScheduled);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)((Object)this);
    }

    public A withConditions(List<DaemonSetCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (DaemonSetCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(DaemonSetCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (DaemonSetCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withCurrentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
        return (A)((Object)this);
    }

    public A withDesiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
        return (A)((Object)this);
    }

    public A withNumberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
        return (A)((Object)this);
    }

    public A withNumberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
        return (A)((Object)this);
    }

    public A withNumberReady(Integer numberReady) {
        this.numberReady = numberReady;
        return (A)((Object)this);
    }

    public A withNumberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
        return (A)((Object)this);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
        return (A)((Object)this);
    }

    public class ConditionsNested<N>
    extends DaemonSetConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        DaemonSetConditionBuilder builder;
        int index;

        ConditionsNested(int index, DaemonSetCondition item) {
            this.index = index;
            this.builder = new DaemonSetConditionBuilder(this, item);
        }

        public N and() {
            return (N)DaemonSetStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

