package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UserSubjectBuilder extends UserSubjectFluentImpl<UserSubjectBuilder> implements VisitableBuilder<UserSubject,UserSubjectBuilder>{
  public UserSubjectBuilder() {
    this(false);
  }
  public UserSubjectBuilder(Boolean validationEnabled) {
    this(new UserSubject(), validationEnabled);
  }
  public UserSubjectBuilder(UserSubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public UserSubjectBuilder(UserSubjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UserSubject(), validationEnabled);
  }
  public UserSubjectBuilder(UserSubjectFluent<?> fluent,UserSubject instance) {
    this(fluent, instance, false);
  }
  public UserSubjectBuilder(UserSubjectFluent<?> fluent,UserSubject instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UserSubjectBuilder(UserSubject instance) {
    this(instance,false);
  }
  public UserSubjectBuilder(UserSubject instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UserSubjectFluent<?> fluent;
  Boolean validationEnabled;
  public UserSubject build() {
    UserSubject buildable = new UserSubject(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}