package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PriorityLevelConfigurationReferenceBuilder extends PriorityLevelConfigurationReferenceFluentImpl<PriorityLevelConfigurationReferenceBuilder> implements VisitableBuilder<PriorityLevelConfigurationReference,PriorityLevelConfigurationReferenceBuilder>{
  public PriorityLevelConfigurationReferenceBuilder() {
    this(false);
  }
  public PriorityLevelConfigurationReferenceBuilder(Boolean validationEnabled) {
    this(new PriorityLevelConfigurationReference(), validationEnabled);
  }
  public PriorityLevelConfigurationReferenceBuilder(PriorityLevelConfigurationReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public PriorityLevelConfigurationReferenceBuilder(PriorityLevelConfigurationReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PriorityLevelConfigurationReference(), validationEnabled);
  }
  public PriorityLevelConfigurationReferenceBuilder(PriorityLevelConfigurationReferenceFluent<?> fluent,PriorityLevelConfigurationReference instance) {
    this(fluent, instance, false);
  }
  public PriorityLevelConfigurationReferenceBuilder(PriorityLevelConfigurationReferenceFluent<?> fluent,PriorityLevelConfigurationReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PriorityLevelConfigurationReferenceBuilder(PriorityLevelConfigurationReference instance) {
    this(instance,false);
  }
  public PriorityLevelConfigurationReferenceBuilder(PriorityLevelConfigurationReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PriorityLevelConfigurationReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public PriorityLevelConfigurationReference build() {
    PriorityLevelConfigurationReference buildable = new PriorityLevelConfigurationReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}