package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PriorityLevelConfigurationStatusBuilder extends PriorityLevelConfigurationStatusFluentImpl<PriorityLevelConfigurationStatusBuilder> implements VisitableBuilder<PriorityLevelConfigurationStatus,PriorityLevelConfigurationStatusBuilder>{
  public PriorityLevelConfigurationStatusBuilder() {
    this(false);
  }
  public PriorityLevelConfigurationStatusBuilder(Boolean validationEnabled) {
    this(new PriorityLevelConfigurationStatus(), validationEnabled);
  }
  public PriorityLevelConfigurationStatusBuilder(PriorityLevelConfigurationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PriorityLevelConfigurationStatusBuilder(PriorityLevelConfigurationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PriorityLevelConfigurationStatus(), validationEnabled);
  }
  public PriorityLevelConfigurationStatusBuilder(PriorityLevelConfigurationStatusFluent<?> fluent,PriorityLevelConfigurationStatus instance) {
    this(fluent, instance, false);
  }
  public PriorityLevelConfigurationStatusBuilder(PriorityLevelConfigurationStatusFluent<?> fluent,PriorityLevelConfigurationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PriorityLevelConfigurationStatusBuilder(PriorityLevelConfigurationStatus instance) {
    this(instance,false);
  }
  public PriorityLevelConfigurationStatusBuilder(PriorityLevelConfigurationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PriorityLevelConfigurationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PriorityLevelConfigurationStatus build() {
    PriorityLevelConfigurationStatus buildable = new PriorityLevelConfigurationStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}