package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountSubjectBuilder extends ServiceAccountSubjectFluent<ServiceAccountSubjectBuilder> implements VisitableBuilder<ServiceAccountSubject,ServiceAccountSubjectBuilder>{
  public ServiceAccountSubjectBuilder() {
    this(false);
  }
  public ServiceAccountSubjectBuilder(Boolean validationEnabled) {
    this(new ServiceAccountSubject(), validationEnabled);
  }
  public ServiceAccountSubjectBuilder(ServiceAccountSubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountSubjectBuilder(ServiceAccountSubjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceAccountSubject(), validationEnabled);
  }
  public ServiceAccountSubjectBuilder(ServiceAccountSubjectFluent<?> fluent,ServiceAccountSubject instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountSubjectBuilder(ServiceAccountSubjectFluent<?> fluent,ServiceAccountSubject instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceAccountSubject());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountSubjectBuilder(ServiceAccountSubject instance) {
    this(instance,false);
  }
  public ServiceAccountSubjectBuilder(ServiceAccountSubject instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceAccountSubject());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceAccountSubjectFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceAccountSubject build() {
    ServiceAccountSubject buildable = new ServiceAccountSubject(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}