package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectBuilder extends SubjectFluent<SubjectBuilder> implements VisitableBuilder<Subject,SubjectBuilder>{
  public SubjectBuilder() {
    this(false);
  }
  public SubjectBuilder(Boolean validationEnabled) {
    this(new Subject(), validationEnabled);
  }
  public SubjectBuilder(SubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Subject(), validationEnabled);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Subject instance) {
    this(fluent, instance, false);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Subject instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Subject());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withUser(instance.getUser());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectBuilder(Subject instance) {
    this(instance,false);
  }
  public SubjectBuilder(Subject instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Subject());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withServiceAccount(instance.getServiceAccount());
      this.withUser(instance.getUser());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withServiceAccount(instance.getServiceAccount());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectFluent<?> fluent;
  Boolean validationEnabled;
  public Subject build() {
    Subject buildable = new Subject(fluent.buildGroup(),fluent.getKind(),fluent.buildServiceAccount(),fluent.buildUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}