package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SubjectFluent<A extends SubjectFluent<A>> extends BaseFluent<A>{
  public SubjectFluent() {
  }
  public SubjectFluent(Subject instance) {
    instance = (instance != null ? instance : new Subject());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withServiceAccount(instance.getServiceAccount());
      this.withUser(instance.getUser());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withServiceAccount(instance.getServiceAccount());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private GroupSubjectBuilder group;
  private String kind;
  private ServiceAccountSubjectBuilder serviceAccount;
  private UserSubjectBuilder user;
  private Map<String,Object> additionalProperties;
  public GroupSubject buildGroup() {
    return this.group!=null ?this.group.build():null;
  }
  public A withGroup(GroupSubject group) {
    _visitables.get("group").remove(this.group);
    if (group!=null){ this.group= new GroupSubjectBuilder(group); _visitables.get("group").add(this.group);} else { this.group = null; _visitables.get("group").remove(this.group); } return (A) this;
  }
  public boolean hasGroup() {
    return this.group != null;
  }
  public A withNewGroup(String name) {
    return (A)withGroup(new GroupSubject(name));
  }
  public GroupNested<A> withNewGroup() {
    return new GroupNested(null);
  }
  public GroupNested<A> withNewGroupLike(GroupSubject item) {
    return new GroupNested(item);
  }
  public GroupNested<A> editGroup() {
    return withNewGroupLike(java.util.Optional.ofNullable(buildGroup()).orElse(null));
  }
  public GroupNested<A> editOrNewGroup() {
    return withNewGroupLike(java.util.Optional.ofNullable(buildGroup()).orElse(new GroupSubjectBuilder().build()));
  }
  public GroupNested<A> editOrNewGroupLike(GroupSubject item) {
    return withNewGroupLike(java.util.Optional.ofNullable(buildGroup()).orElse(item));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public ServiceAccountSubject buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(ServiceAccountSubject serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ServiceAccountSubjectBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} else { this.serviceAccount = null; _visitables.get("serviceAccount").remove(this.serviceAccount); } return (A) this;
  }
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public A withNewServiceAccount(String name,String namespace) {
    return (A)withServiceAccount(new ServiceAccountSubject(name, namespace));
  }
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  public ServiceAccountNested<A> withNewServiceAccountLike(ServiceAccountSubject item) {
    return new ServiceAccountNested(item);
  }
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ServiceAccountSubjectBuilder().build()));
  }
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ServiceAccountSubject item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  public UserSubject buildUser() {
    return this.user!=null ?this.user.build():null;
  }
  public A withUser(UserSubject user) {
    _visitables.get("user").remove(this.user);
    if (user!=null){ this.user= new UserSubjectBuilder(user); _visitables.get("user").add(this.user);} else { this.user = null; _visitables.get("user").remove(this.user); } return (A) this;
  }
  public boolean hasUser() {
    return this.user != null;
  }
  public A withNewUser(String name) {
    return (A)withUser(new UserSubject(name));
  }
  public UserNested<A> withNewUser() {
    return new UserNested(null);
  }
  public UserNested<A> withNewUserLike(UserSubject item) {
    return new UserNested(item);
  }
  public UserNested<A> editUser() {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(null));
  }
  public UserNested<A> editOrNewUser() {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(new UserSubjectBuilder().build()));
  }
  public UserNested<A> editOrNewUserLike(UserSubject item) {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubjectFluent that = (SubjectFluent) o;
    if (!java.util.Objects.equals(group, that.group)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    if (!java.util.Objects.equals(user, that.user)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(group,  kind,  serviceAccount,  user,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class GroupNested<N> extends GroupSubjectFluent<GroupNested<N>> implements Nested<N>{
    GroupNested(GroupSubject item) {
      this.builder = new GroupSubjectBuilder(this, item);
    }
    GroupSubjectBuilder builder;
    public N and() {
      return (N) SubjectFluent.this.withGroup(builder.build());
    }
    public N endGroup() {
      return and();
    }
    
  }
  public class ServiceAccountNested<N> extends ServiceAccountSubjectFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ServiceAccountSubject item) {
      this.builder = new ServiceAccountSubjectBuilder(this, item);
    }
    ServiceAccountSubjectBuilder builder;
    public N and() {
      return (N) SubjectFluent.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  public class UserNested<N> extends UserSubjectFluent<UserNested<N>> implements Nested<N>{
    UserNested(UserSubject item) {
      this.builder = new UserSubjectBuilder(this, item);
    }
    UserSubjectBuilder builder;
    public N and() {
      return (N) SubjectFluent.this.withUser(builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}