package io.fabric8.kubernetes.api.model.flowcontrol.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlowSchemaStatusBuilder extends FlowSchemaStatusFluent<FlowSchemaStatusBuilder> implements VisitableBuilder<FlowSchemaStatus,FlowSchemaStatusBuilder>{
  public FlowSchemaStatusBuilder() {
    this(false);
  }
  public FlowSchemaStatusBuilder(Boolean validationEnabled) {
    this(new FlowSchemaStatus(), validationEnabled);
  }
  public FlowSchemaStatusBuilder(FlowSchemaStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public FlowSchemaStatusBuilder(FlowSchemaStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FlowSchemaStatus(), validationEnabled);
  }
  public FlowSchemaStatusBuilder(FlowSchemaStatusFluent<?> fluent,FlowSchemaStatus instance) {
    this(fluent, instance, false);
  }
  public FlowSchemaStatusBuilder(FlowSchemaStatusFluent<?> fluent,FlowSchemaStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FlowSchemaStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withConditions(instance.getConditions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FlowSchemaStatusBuilder(FlowSchemaStatus instance) {
    this(instance,false);
  }
  public FlowSchemaStatusBuilder(FlowSchemaStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FlowSchemaStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withConditions(instance.getConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FlowSchemaStatusFluent<?> fluent;
  Boolean validationEnabled;
  public FlowSchemaStatus build() {
    FlowSchemaStatus buildable = new FlowSchemaStatus(fluent.buildConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}