package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageVersionStatusBuilder extends StorageVersionStatusFluent<StorageVersionStatusBuilder> implements VisitableBuilder<StorageVersionStatus,StorageVersionStatusBuilder>{
  public StorageVersionStatusBuilder() {
    this(false);
  }
  public StorageVersionStatusBuilder(Boolean validationEnabled) {
    this(new StorageVersionStatus(), validationEnabled);
  }
  public StorageVersionStatusBuilder(StorageVersionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageVersionStatusBuilder(StorageVersionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageVersionStatus(), validationEnabled);
  }
  public StorageVersionStatusBuilder(StorageVersionStatusFluent<?> fluent,StorageVersionStatus instance) {
    this(fluent, instance, false);
  }
  public StorageVersionStatusBuilder(StorageVersionStatusFluent<?> fluent,StorageVersionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StorageVersionStatus());

    if (instance != null) {
      fluent.withCommonEncodingVersion(instance.getCommonEncodingVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withStorageVersions(instance.getStorageVersions());
      fluent.withCommonEncodingVersion(instance.getCommonEncodingVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withStorageVersions(instance.getStorageVersions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageVersionStatusBuilder(StorageVersionStatus instance) {
    this(instance,false);
  }
  public StorageVersionStatusBuilder(StorageVersionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StorageVersionStatus());

    if (instance != null) {
      this.withCommonEncodingVersion(instance.getCommonEncodingVersion());
      this.withConditions(instance.getConditions());
      this.withStorageVersions(instance.getStorageVersions());
      this.withCommonEncodingVersion(instance.getCommonEncodingVersion());
      this.withConditions(instance.getConditions());
      this.withStorageVersions(instance.getStorageVersions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageVersionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public StorageVersionStatus build() {
    StorageVersionStatus buildable = new StorageVersionStatus(fluent.getCommonEncodingVersion(),fluent.buildConditions(),fluent.buildStorageVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}