package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FlowSchemaSpecFluent<A extends FlowSchemaSpecFluent<A>> extends BaseFluent<A>{
  public FlowSchemaSpecFluent() {
  }
  
  public FlowSchemaSpecFluent(FlowSchemaSpec instance) {
    this.copyInstance(instance);
  }
  private FlowDistinguisherMethodBuilder distinguisherMethod;
  private Integer matchingPrecedence;
  private PriorityLevelConfigurationReferenceBuilder priorityLevelConfiguration;
  private ArrayList<PolicyRulesWithSubjectsBuilder> rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FlowSchemaSpec instance) {
    instance = (instance != null ? instance : new FlowSchemaSpec());
    if (instance != null) {
          this.withDistinguisherMethod(instance.getDistinguisherMethod());
          this.withMatchingPrecedence(instance.getMatchingPrecedence());
          this.withPriorityLevelConfiguration(instance.getPriorityLevelConfiguration());
          this.withRules(instance.getRules());
          this.withDistinguisherMethod(instance.getDistinguisherMethod());
          this.withMatchingPrecedence(instance.getMatchingPrecedence());
          this.withPriorityLevelConfiguration(instance.getPriorityLevelConfiguration());
          this.withRules(instance.getRules());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public FlowDistinguisherMethod buildDistinguisherMethod() {
    return this.distinguisherMethod != null ? this.distinguisherMethod.build() : null;
  }
  
  public A withDistinguisherMethod(FlowDistinguisherMethod distinguisherMethod) {
    this._visitables.remove(this.distinguisherMethod);
    if (distinguisherMethod != null) {
        this.distinguisherMethod = new FlowDistinguisherMethodBuilder(distinguisherMethod);
        this._visitables.get("distinguisherMethod").add(this.distinguisherMethod);
    } else {
        this.distinguisherMethod = null;
        this._visitables.get("distinguisherMethod").remove(this.distinguisherMethod);
    }
    return (A) this;
  }
  
  public boolean hasDistinguisherMethod() {
    return this.distinguisherMethod != null;
  }
  
  public A withNewDistinguisherMethod(String type) {
    return (A)withDistinguisherMethod(new FlowDistinguisherMethod(type));
  }
  
  public DistinguisherMethodNested<A> withNewDistinguisherMethod() {
    return new DistinguisherMethodNested(null);
  }
  
  public DistinguisherMethodNested<A> withNewDistinguisherMethodLike(FlowDistinguisherMethod item) {
    return new DistinguisherMethodNested(item);
  }
  
  public DistinguisherMethodNested<A> editDistinguisherMethod() {
    return withNewDistinguisherMethodLike(java.util.Optional.ofNullable(buildDistinguisherMethod()).orElse(null));
  }
  
  public DistinguisherMethodNested<A> editOrNewDistinguisherMethod() {
    return withNewDistinguisherMethodLike(java.util.Optional.ofNullable(buildDistinguisherMethod()).orElse(new FlowDistinguisherMethodBuilder().build()));
  }
  
  public DistinguisherMethodNested<A> editOrNewDistinguisherMethodLike(FlowDistinguisherMethod item) {
    return withNewDistinguisherMethodLike(java.util.Optional.ofNullable(buildDistinguisherMethod()).orElse(item));
  }
  
  public Integer getMatchingPrecedence() {
    return this.matchingPrecedence;
  }
  
  public A withMatchingPrecedence(Integer matchingPrecedence) {
    this.matchingPrecedence = matchingPrecedence;
    return (A) this;
  }
  
  public boolean hasMatchingPrecedence() {
    return this.matchingPrecedence != null;
  }
  
  public PriorityLevelConfigurationReference buildPriorityLevelConfiguration() {
    return this.priorityLevelConfiguration != null ? this.priorityLevelConfiguration.build() : null;
  }
  
  public A withPriorityLevelConfiguration(PriorityLevelConfigurationReference priorityLevelConfiguration) {
    this._visitables.remove(this.priorityLevelConfiguration);
    if (priorityLevelConfiguration != null) {
        this.priorityLevelConfiguration = new PriorityLevelConfigurationReferenceBuilder(priorityLevelConfiguration);
        this._visitables.get("priorityLevelConfiguration").add(this.priorityLevelConfiguration);
    } else {
        this.priorityLevelConfiguration = null;
        this._visitables.get("priorityLevelConfiguration").remove(this.priorityLevelConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasPriorityLevelConfiguration() {
    return this.priorityLevelConfiguration != null;
  }
  
  public A withNewPriorityLevelConfiguration(String name) {
    return (A)withPriorityLevelConfiguration(new PriorityLevelConfigurationReference(name));
  }
  
  public PriorityLevelConfigurationNested<A> withNewPriorityLevelConfiguration() {
    return new PriorityLevelConfigurationNested(null);
  }
  
  public PriorityLevelConfigurationNested<A> withNewPriorityLevelConfigurationLike(PriorityLevelConfigurationReference item) {
    return new PriorityLevelConfigurationNested(item);
  }
  
  public PriorityLevelConfigurationNested<A> editPriorityLevelConfiguration() {
    return withNewPriorityLevelConfigurationLike(java.util.Optional.ofNullable(buildPriorityLevelConfiguration()).orElse(null));
  }
  
  public PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfiguration() {
    return withNewPriorityLevelConfigurationLike(java.util.Optional.ofNullable(buildPriorityLevelConfiguration()).orElse(new PriorityLevelConfigurationReferenceBuilder().build()));
  }
  
  public PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfigurationLike(PriorityLevelConfigurationReference item) {
    return withNewPriorityLevelConfigurationLike(java.util.Optional.ofNullable(buildPriorityLevelConfiguration()).orElse(item));
  }
  
  public A addToRules(int index,PolicyRulesWithSubjects item) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();}
    PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  
  public A setToRules(int index,PolicyRulesWithSubjects item) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();}
    PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  
  public A addToRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.PolicyRulesWithSubjects... items) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();}
    for (PolicyRulesWithSubjects item : items) {PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A addAllToRules(Collection<PolicyRulesWithSubjects> items) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();}
    for (PolicyRulesWithSubjects item : items) {PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A removeFromRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.PolicyRulesWithSubjects... items) {
    if (this.rules == null) return (A)this;
    for (PolicyRulesWithSubjects item : items) {PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRules(Collection<PolicyRulesWithSubjects> items) {
    if (this.rules == null) return (A)this;
    for (PolicyRulesWithSubjects item : items) {PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRules(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<PolicyRulesWithSubjectsBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      PolicyRulesWithSubjectsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PolicyRulesWithSubjects> buildRules() {
    return this.rules != null ? build(rules) : null;
  }
  
  public PolicyRulesWithSubjects buildRule(int index) {
    return this.rules.get(index).build();
  }
  
  public PolicyRulesWithSubjects buildFirstRule() {
    return this.rules.get(0).build();
  }
  
  public PolicyRulesWithSubjects buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  
  public PolicyRulesWithSubjects buildMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
      for (PolicyRulesWithSubjectsBuilder item : rules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
      for (PolicyRulesWithSubjectsBuilder item : rules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRules(List<PolicyRulesWithSubjects> rules) {
    if (this.rules != null) {
      this._visitables.get("rules").clear();
    }
    if (rules != null) {
        this.rules = new ArrayList();
        for (PolicyRulesWithSubjects item : rules) {
          this.addToRules(item);
        }
    } else {
      this.rules = null;
    }
    return (A) this;
  }
  
  public A withRules(io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.PolicyRulesWithSubjects... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (PolicyRulesWithSubjects item :rules){ this.addToRules(item);}} return (A) this;
  }
  
  public boolean hasRules() {
    return this.rules != null && !this.rules.isEmpty();
  }
  
  public RulesNested<A> addNewRule() {
    return new RulesNested(-1, null);
  }
  
  public RulesNested<A> addNewRuleLike(PolicyRulesWithSubjects item) {
    return new RulesNested(-1, item);
  }
  
  public RulesNested<A> setNewRuleLike(int index,PolicyRulesWithSubjects item) {
    return new RulesNested(index, item);
  }
  
  public RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  
  public RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FlowSchemaSpecFluent that = (FlowSchemaSpecFluent) o;
    if (!java.util.Objects.equals(distinguisherMethod, that.distinguisherMethod)) return false;
    if (!java.util.Objects.equals(matchingPrecedence, that.matchingPrecedence)) return false;
    if (!java.util.Objects.equals(priorityLevelConfiguration, that.priorityLevelConfiguration)) return false;
    if (!java.util.Objects.equals(rules, that.rules)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(distinguisherMethod,  matchingPrecedence,  priorityLevelConfiguration,  rules,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (distinguisherMethod != null) { sb.append("distinguisherMethod:"); sb.append(distinguisherMethod + ","); }
    if (matchingPrecedence != null) { sb.append("matchingPrecedence:"); sb.append(matchingPrecedence + ","); }
    if (priorityLevelConfiguration != null) { sb.append("priorityLevelConfiguration:"); sb.append(priorityLevelConfiguration + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DistinguisherMethodNested<N> extends FlowDistinguisherMethodFluent<DistinguisherMethodNested<N>> implements Nested<N>{
    DistinguisherMethodNested(FlowDistinguisherMethod item) {
      this.builder = new FlowDistinguisherMethodBuilder(this, item);
    }
    FlowDistinguisherMethodBuilder builder;
    
    public N and() {
      return (N) FlowSchemaSpecFluent.this.withDistinguisherMethod(builder.build());
    }
    
    public N endDistinguisherMethod() {
      return and();
    }
    
  
  }
  public class PriorityLevelConfigurationNested<N> extends PriorityLevelConfigurationReferenceFluent<PriorityLevelConfigurationNested<N>> implements Nested<N>{
    PriorityLevelConfigurationNested(PriorityLevelConfigurationReference item) {
      this.builder = new PriorityLevelConfigurationReferenceBuilder(this, item);
    }
    PriorityLevelConfigurationReferenceBuilder builder;
    
    public N and() {
      return (N) FlowSchemaSpecFluent.this.withPriorityLevelConfiguration(builder.build());
    }
    
    public N endPriorityLevelConfiguration() {
      return and();
    }
    
  
  }
  public class RulesNested<N> extends PolicyRulesWithSubjectsFluent<RulesNested<N>> implements Nested<N>{
    RulesNested(int index,PolicyRulesWithSubjects item) {
      this.index = index;
      this.builder = new PolicyRulesWithSubjectsBuilder(this, item);
    }
    PolicyRulesWithSubjectsBuilder builder;
    int index;
    
    public N and() {
      return (N) FlowSchemaSpecFluent.this.setToRules(index,builder.build());
    }
    
    public N endRule() {
      return and();
    }
    
  
  }

}