package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GatewayClassBuilder extends GatewayClassFluent<GatewayClassBuilder> implements VisitableBuilder<GatewayClass,GatewayClassBuilder>{
  public GatewayClassBuilder() {
    this(new GatewayClass());
  }
  
  public GatewayClassBuilder(GatewayClassFluent<?> fluent) {
    this(fluent, new GatewayClass());
  }
  
  public GatewayClassBuilder(GatewayClassFluent<?> fluent,GatewayClass instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GatewayClassBuilder(GatewayClass instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GatewayClassFluent<?> fluent;
  
  public GatewayClass build() {
    GatewayClass buildable = new GatewayClass(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}