package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GatewayClassSpecFluentImpl<A extends GatewayClassSpecFluent<A>> extends BaseFluent<A> implements GatewayClassSpecFluent<A>{
  public GatewayClassSpecFluentImpl() {
  }
  public GatewayClassSpecFluentImpl(GatewayClassSpec instance) {
    this.withControllerName(instance.getControllerName()); 
    this.withDescription(instance.getDescription()); 
    this.withParametersRef(instance.getParametersRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String controllerName;
  private String description;
  private ParametersReferenceBuilder parametersRef;
  private Map<String,Object> additionalProperties;
  public String getControllerName() {
    return this.controllerName;
  }
  public A withControllerName(String controllerName) {
    this.controllerName=controllerName; return (A) this;
  }
  public Boolean hasControllerName() {
    return this.controllerName != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  
  /**
   * This method has been deprecated, please use method buildParametersRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ParametersReference getParametersRef() {
    return this.parametersRef!=null ?this.parametersRef.build():null;
  }
  public ParametersReference buildParametersRef() {
    return this.parametersRef!=null ?this.parametersRef.build():null;
  }
  public A withParametersRef(ParametersReference parametersRef) {
    _visitables.get("parametersRef").remove(this.parametersRef);
    if (parametersRef!=null){ this.parametersRef= new ParametersReferenceBuilder(parametersRef); _visitables.get("parametersRef").add(this.parametersRef);} else { this.parametersRef = null; _visitables.get("parametersRef").remove(this.parametersRef); } return (A) this;
  }
  public Boolean hasParametersRef() {
    return this.parametersRef != null;
  }
  public A withNewParametersRef(String group,String kind,String name,String namespace) {
    return (A)withParametersRef(new ParametersReference(group, kind, name, namespace));
  }
  public GatewayClassSpecFluent.ParametersRefNested<A> withNewParametersRef() {
    return new GatewayClassSpecFluentImpl.ParametersRefNestedImpl();
  }
  public GatewayClassSpecFluent.ParametersRefNested<A> withNewParametersRefLike(ParametersReference item) {
    return new GatewayClassSpecFluentImpl.ParametersRefNestedImpl(item);
  }
  public GatewayClassSpecFluent.ParametersRefNested<A> editParametersRef() {
    return withNewParametersRefLike(getParametersRef());
  }
  public GatewayClassSpecFluent.ParametersRefNested<A> editOrNewParametersRef() {
    return withNewParametersRefLike(getParametersRef() != null ? getParametersRef(): new ParametersReferenceBuilder().build());
  }
  public GatewayClassSpecFluent.ParametersRefNested<A> editOrNewParametersRefLike(ParametersReference item) {
    return withNewParametersRefLike(getParametersRef() != null ? getParametersRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GatewayClassSpecFluentImpl that = (GatewayClassSpecFluentImpl) o;
    if (controllerName != null ? !controllerName.equals(that.controllerName) :that.controllerName != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (parametersRef != null ? !parametersRef.equals(that.parametersRef) :that.parametersRef != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(controllerName,  description,  parametersRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controllerName != null) { sb.append("controllerName:"); sb.append(controllerName + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (parametersRef != null) { sb.append("parametersRef:"); sb.append(parametersRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ParametersRefNestedImpl<N> extends ParametersReferenceFluentImpl<GatewayClassSpecFluent.ParametersRefNested<N>> implements GatewayClassSpecFluent.ParametersRefNested<N>,Nested<N>{
    ParametersRefNestedImpl(ParametersReference item) {
      this.builder = new ParametersReferenceBuilder(this, item);
    }
    ParametersRefNestedImpl() {
      this.builder = new ParametersReferenceBuilder(this);
    }
    ParametersReferenceBuilder builder;
    public N and() {
      return (N) GatewayClassSpecFluentImpl.this.withParametersRef(builder.build());
    }
    public N endParametersRef() {
      return and();
    }
    
  }
  
}