package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParametersReferenceBuilder extends ParametersReferenceFluentImpl<ParametersReferenceBuilder> implements VisitableBuilder<ParametersReference,ParametersReferenceBuilder>{
  public ParametersReferenceBuilder() {
    this(false);
  }
  public ParametersReferenceBuilder(Boolean validationEnabled) {
    this(new ParametersReference(), validationEnabled);
  }
  public ParametersReferenceBuilder(ParametersReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ParametersReferenceBuilder(ParametersReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParametersReference(), validationEnabled);
  }
  public ParametersReferenceBuilder(ParametersReferenceFluent<?> fluent,ParametersReference instance) {
    this(fluent, instance, false);
  }
  public ParametersReferenceBuilder(ParametersReferenceFluent<?> fluent,ParametersReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ParametersReferenceBuilder(ParametersReference instance) {
    this(instance,false);
  }
  public ParametersReferenceBuilder(ParametersReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ParametersReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ParametersReference build() {
    ParametersReference buildable = new ParametersReference(fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}