package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteGroupKindBuilder extends RouteGroupKindFluentImpl<RouteGroupKindBuilder> implements VisitableBuilder<RouteGroupKind,RouteGroupKindBuilder>{
  public RouteGroupKindBuilder() {
    this(false);
  }
  public RouteGroupKindBuilder(Boolean validationEnabled) {
    this(new RouteGroupKind(), validationEnabled);
  }
  public RouteGroupKindBuilder(RouteGroupKindFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteGroupKindBuilder(RouteGroupKindFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteGroupKind(), validationEnabled);
  }
  public RouteGroupKindBuilder(RouteGroupKindFluent<?> fluent,RouteGroupKind instance) {
    this(fluent, instance, false);
  }
  public RouteGroupKindBuilder(RouteGroupKindFluent<?> fluent,RouteGroupKind instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteGroupKindBuilder(RouteGroupKind instance) {
    this(instance,false);
  }
  public RouteGroupKindBuilder(RouteGroupKind instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RouteGroupKindFluent<?> fluent;
  Boolean validationEnabled;
  public RouteGroupKind build() {
    RouteGroupKind buildable = new RouteGroupKind(fluent.getGroup(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}