package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPQueryParamMatchBuilder extends HTTPQueryParamMatchFluentImpl<HTTPQueryParamMatchBuilder> implements VisitableBuilder<HTTPQueryParamMatch,HTTPQueryParamMatchBuilder>{
  public HTTPQueryParamMatchBuilder() {
    this(false);
  }
  public HTTPQueryParamMatchBuilder(Boolean validationEnabled) {
    this(new HTTPQueryParamMatch(), validationEnabled);
  }
  public HTTPQueryParamMatchBuilder(HTTPQueryParamMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPQueryParamMatchBuilder(HTTPQueryParamMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPQueryParamMatch(), validationEnabled);
  }
  public HTTPQueryParamMatchBuilder(HTTPQueryParamMatchFluent<?> fluent,HTTPQueryParamMatch instance) {
    this(fluent, instance, false);
  }
  public HTTPQueryParamMatchBuilder(HTTPQueryParamMatchFluent<?> fluent,HTTPQueryParamMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPQueryParamMatchBuilder(HTTPQueryParamMatch instance) {
    this(instance,false);
  }
  public HTTPQueryParamMatchBuilder(HTTPQueryParamMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPQueryParamMatchFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPQueryParamMatch build() {
    HTTPQueryParamMatch buildable = new HTTPQueryParamMatch(fluent.getName(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}