package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayStatusBuilder extends GatewayStatusFluentImpl<GatewayStatusBuilder> implements VisitableBuilder<GatewayStatus,GatewayStatusBuilder>{
  public GatewayStatusBuilder() {
    this(false);
  }
  public GatewayStatusBuilder(Boolean validationEnabled) {
    this(new GatewayStatus(), validationEnabled);
  }
  public GatewayStatusBuilder(GatewayStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayStatusBuilder(GatewayStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayStatus(), validationEnabled);
  }
  public GatewayStatusBuilder(GatewayStatusFluent<?> fluent,GatewayStatus instance) {
    this(fluent, instance, false);
  }
  public GatewayStatusBuilder(GatewayStatusFluent<?> fluent,GatewayStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddresses(instance.getAddresses()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withListeners(instance.getListeners()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GatewayStatusBuilder(GatewayStatus instance) {
    this(instance,false);
  }
  public GatewayStatusBuilder(GatewayStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddresses(instance.getAddresses()); 
    this.withConditions(instance.getConditions()); 
    this.withListeners(instance.getListeners()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GatewayStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayStatus build() {
    GatewayStatus buildable = new GatewayStatus(fluent.getAddresses(),fluent.getConditions(),fluent.getListeners());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}